/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.symbol;

import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.expression.StartInstructionValue;
import ghidra.app.plugin.processors.sleigh.symbol.SpecificSymbol;
import ghidra.pcode.utils.SlaFormat;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import java.util.ArrayList;

public class StartSymbol
extends SpecificSymbol {
    private PatternExpression patexp;

    @Override
    public PatternExpression getPatternExpression() {
        return this.patexp;
    }

    @Override
    public void getFixedHandle(FixedHandle hand, ParserWalker walker) {
        hand.space = walker.getCurSpace();
        hand.offset_space = null;
        hand.offset_offset = walker.getAddr().getOffset();
        hand.size = hand.space.getPointerSize();
    }

    @Override
    public String print(ParserWalker walker) throws MemoryAccessException {
        long val = walker.getAddr().getOffset();
        return "0x" + Long.toHexString(val);
    }

    @Override
    public void printList(ParserWalker walker, ArrayList<Object> list) {
        list.add(walker.getParentHandle());
    }

    @Override
    public void decode(Decoder decoder, SleighLanguage sleigh) throws DecoderException {
        this.patexp = new StartInstructionValue();
        decoder.closeElement(SlaFormat.ELEM_START_SYM.id());
    }
}

