/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import ghidra.program.database.symbol.ClassSymbol;
import ghidra.program.database.symbol.NamespaceManager;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

class GhidraClassDB
implements GhidraClass {
    private ClassSymbol symbol;
    private NamespaceManager namespaceMgr;

    GhidraClassDB(ClassSymbol symbol, NamespaceManager namespaceMgr) {
        this.symbol = symbol;
        this.namespaceMgr = namespaceMgr;
    }

    @Override
    public Symbol getSymbol() {
        return this.symbol;
    }

    @Override
    public boolean isExternal() {
        return this.symbol.isExternal();
    }

    @Override
    public String getName() {
        return this.symbol.getName();
    }

    public void setName(String name, SourceType source, boolean checkForDuplicates) throws DuplicateNameException, InvalidInputException {
        try {
            this.symbol.doSetNameAndNamespace(name, this.symbol.getParentNamespace(), source, checkForDuplicates);
        }
        catch (CircularDependencyException circularDependencyException) {
            // empty catch block
        }
    }

    @Override
    public long getID() {
        return this.symbol.getID();
    }

    @Override
    public Namespace getParentNamespace() {
        return this.symbol.getParentNamespace();
    }

    @Override
    public AddressSetView getBody() {
        return this.namespaceMgr.getAddressSet(this);
    }

    @Override
    public String getName(boolean includeNamespacePath) {
        return this.symbol.getName(includeNamespacePath);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GhidraClassDB gc = (GhidraClassDB)obj;
        return this.symbol == gc.symbol;
    }

    @Override
    public void setParentNamespace(Namespace parentNamespace) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        this.symbol.setNamespace(parentNamespace);
    }

    public String toString() {
        return this.symbol.getName(true) + " (GhidraClass)";
    }
}

