/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import generic.util.FlattenedIterator;
import generic.util.PeekableIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class AddressIteratorAdapter
extends FlattenedIterator<AddressRange, Address>
implements AddressIterator {
    public static Iterable<Address> forRange(AddressRange range, boolean forward) {
        return () -> forward ? new ForwardAddressIterator(range) : new BackwardAddressIterator(range);
    }

    public AddressIteratorAdapter(Iterator<AddressRange> outer, boolean forward) {
        super(outer, forward ? ForwardAddressIterator::new : BackwardAddressIterator::new);
    }

    public AddressIteratorAdapter(Iterator<AddressRange> outer, Address start, boolean forward) {
        super(outer, forward ? ar -> {
            if (!ar.contains(start)) {
                return new ForwardAddressIterator((AddressRange)ar);
            }
            return new ForwardAddressIterator(start, ar.getMaxAddress());
        } : ar -> {
            if (!ar.contains(start)) {
                return new BackwardAddressIterator((AddressRange)ar);
            }
            return new BackwardAddressIterator(ar.getMinAddress(), start);
        });
    }

    @Override
    public Iterator<Address> iterator() {
        return this;
    }

    protected static class BackwardAddressIterator
    implements PeekableIterator<Address> {
        private final Address end;
        private Address cur;

        public BackwardAddressIterator(AddressRange range) {
            this(range.getMinAddress(), range.getMaxAddress());
        }

        public BackwardAddressIterator(Address min, Address max) {
            this.end = min;
            this.cur = max;
        }

        public boolean hasNext() {
            return this.cur != null && this.cur.compareTo(this.end) >= 0;
        }

        public Address next() {
            Address next = this.cur;
            this.cur = this.cur.previous();
            return next;
        }

        public Address peek() throws NoSuchElementException {
            return this.cur;
        }
    }

    protected static class ForwardAddressIterator
    implements PeekableIterator<Address> {
        private final Address end;
        private Address cur;

        public ForwardAddressIterator(AddressRange range) {
            this(range.getMinAddress(), range.getMaxAddress());
        }

        public ForwardAddressIterator(Address min, Address max) {
            this.end = max;
            this.cur = min;
        }

        public boolean hasNext() {
            return this.cur != null && this.cur.compareTo(this.end) <= 0;
        }

        public Address next() {
            Address next = this.cur;
            this.cur = this.cur.next();
            return next;
        }

        public Address peek() throws NoSuchElementException {
            return this.cur;
        }
    }
}

