/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.naming;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDMangUtils;
import mdemangler.MDParsableItem;
import mdemangler.naming.MDFragmentName;
import mdemangler.naming.MDNestedName;
import mdemangler.naming.MDNumberedNamespace;
import mdemangler.naming.MDQualification;
import mdemangler.naming.MDReusableName;

public class MDQualifier
extends MDParsableItem {
    private static final String ANONYMOUS_NAMESPACE = "`anonymous namespace'";
    private static final String UNKNOWN_NAMESPACE = "MDMANG_UNK_QUALIFICATION";
    private MDReusableName name;
    private MDReusableName nameAnonymous;
    private MDReusableName nameInterface;
    private MDNestedName nameNested;
    private MDNumberedNamespace nameNumbered;
    private String nameQ;
    private String nameC;

    public MDQualifier(MDMang dmang) {
        super(dmang);
    }

    public boolean isInterface() {
        return this.nameInterface != null;
    }

    public boolean isNested() {
        return this.nameNested != null;
    }

    public boolean isAnon() {
        return this.nameAnonymous != null;
    }

    public boolean isLocalNamespace() {
        return this.nameNumbered != null;
    }

    public boolean isNameC() {
        return this.nameC != null;
    }

    public boolean isNameQ() {
        return this.nameQ != null;
    }

    public MDNestedName getNested() {
        return this.nameNested;
    }

    public String getAnonymousName() {
        return this.nameAnonymous.getName();
    }

    public String getLocalNamespace() {
        return this.nameNumbered.getName();
    }

    public String getLocalNamespaceNumber() {
        return this.nameNumbered.getNumber().toString();
    }

    public String getNameC() {
        return this.nameC;
    }

    public String getNameQ() {
        return this.nameQ;
    }

    @Override
    public void insert(StringBuilder builder) {
        if (this.name != null) {
            this.name.insert(builder);
        } else if (this.nameAnonymous != null) {
            if (this.dmang.getOutputOptions().useEncodedAnonymousNamespace()) {
                this.dmang.insertString(builder, MDMangUtils.createStandardAnonymousNamespaceNode(this.nameAnonymous.getName()));
            } else {
                this.dmang.insertString(builder, ANONYMOUS_NAMESPACE);
            }
        } else if (this.nameInterface != null) {
            this.nameInterface.insert(builder);
        } else if (this.nameNested != null) {
            this.nameNested.insert(builder);
        } else if (this.nameNumbered != null) {
            this.nameNumbered.insert(builder);
        } else if (this.nameQ != null) {
            this.dmang.insertString(builder, this.nameQ);
        } else if (this.nameC != null) {
            this.dmang.insertString(builder, this.nameC);
        } else {
            this.dmang.insertString(builder, UNKNOWN_NAMESPACE);
        }
    }

    @Override
    protected void parseInternal() throws MDException {
        if (this.dmang.peek() == '?') {
            switch (this.dmang.peek(1)) {
                case '?': {
                    this.nameNested = new MDNestedName(this.dmang);
                    this.nameNested.parse();
                    break;
                }
                case '$': {
                    this.name = new MDReusableName(this.dmang);
                    this.name.parse();
                    break;
                }
                case 'A': {
                    this.dmang.parseInfoPush(0, "FragmentName from Anonymous Namespace");
                    this.dmang.increment();
                    this.nameAnonymous = new MDReusableName(this.dmang);
                    this.nameAnonymous.parse();
                    this.dmang.parseInfoPop();
                    break;
                }
                case 'I': {
                    this.dmang.parseInfoPush(0, "InterfaceName from NameFragment");
                    this.dmang.increment();
                    this.dmang.increment();
                    this.nameInterface = new MDReusableName(this.dmang);
                    this.nameInterface.parse();
                    this.dmang.parseInfoPop();
                    break;
                }
                case 'C': {
                    if (this.dmang.processQualCAsSpecialFragment()) {
                        this.dmang.parseInfoPush(0, "NameC");
                        this.dmang.increment();
                        this.dmang.increment();
                        MDFragmentName fragName = new MDFragmentName(this.dmang);
                        fragName.keepTerminator();
                        fragName.parse();
                        this.nameC = fragName.toString();
                        this.dmang.parseInfoPop();
                        break;
                    }
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'B': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': {
                    this.dmang.increment();
                    this.nameNumbered = new MDNumberedNamespace(this.dmang);
                    this.nameNumbered.parse();
                    break;
                }
                case 'Q': {
                    this.dmang.parseInfoPush(0, "InterfaceName from QualifiedName");
                    this.dmang.increment();
                    this.dmang.increment();
                    MDQualification qualName = new MDQualification(this.dmang);
                    qualName.parse();
                    StringBuilder nameQBuilder = new StringBuilder();
                    qualName.insert(nameQBuilder);
                    this.dmang.insertString(nameQBuilder, "[");
                    this.dmang.appendString(nameQBuilder, "]");
                    this.nameQ = nameQBuilder.toString();
                    this.dmang.parseInfoPop();
                    break;
                }
                default: {
                    if (!this.dmang.isLlvmProcessingMode()) {
                        throw new MDException("SpecialName not expected in qualification list");
                    }
                    this.nameNested = new MDNestedName(this.dmang);
                    this.nameNested.parse();
                    break;
                }
            }
        } else {
            this.name = new MDReusableName(this.dmang);
            this.name.parse();
        }
    }
}

