/*
 * Decompiled with CFR 0.152.
 */
package sarif;

import com.contrastsecurity.sarif.Address;
import com.contrastsecurity.sarif.Artifact;
import com.contrastsecurity.sarif.ArtifactContent;
import com.contrastsecurity.sarif.ArtifactLocation;
import com.contrastsecurity.sarif.Edge;
import com.contrastsecurity.sarif.Graph;
import com.contrastsecurity.sarif.Location;
import com.contrastsecurity.sarif.LogicalLocation;
import com.contrastsecurity.sarif.Node;
import com.contrastsecurity.sarif.PhysicalLocation;
import com.contrastsecurity.sarif.ReportingDescriptor;
import com.contrastsecurity.sarif.ReportingDescriptorReference;
import com.contrastsecurity.sarif.Run;
import com.contrastsecurity.sarif.ToolComponent;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ghidra.framework.store.LockException;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.util.encoders.Base64;

public class SarifUtils {
    private static Run currentRun = null;
    private static LogicalLocation[] llocs;
    private static List<Address> addresses;
    private static Map<String, Long> nameToOffset;
    private static Map<String, LogicalLocation[]> nodeLocs;
    private static Map<String, String> edgeSrcs;
    private static Map<String, String> edgeDsts;
    private static Map<String, Set<String>> edgeDescs;
    private static boolean populating;

    public static JsonArray setLocations(ghidra.program.model.address.Address min, ghidra.program.model.address.Address max) {
        AddressSet set = new AddressSet(min, max);
        return SarifUtils.setLocations((AddressSetView)set);
    }

    public static JsonArray setLocations(AddressSetView set) {
        JsonArray locations = new JsonArray();
        AddressRangeIterator addressRanges = set.getAddressRanges();
        while (addressRanges.hasNext()) {
            JsonObject element = new JsonObject();
            locations.add((JsonElement)element);
            AddressRange next = (AddressRange)addressRanges.next();
            JsonObject ploc = new JsonObject();
            element.add("physicalLocation", (JsonElement)ploc);
            JsonObject address = new JsonObject();
            ploc.add("address", (JsonElement)address);
            address.addProperty("absoluteAddress", (Number)next.getMinAddress().getOffset());
            address.addProperty("length", (Number)next.getLength());
            ghidra.program.model.address.Address minAddress = next.getMinAddress();
            AddressSpace addressSpace = minAddress.getAddressSpace();
            if (!addressSpace.showSpaceName()) continue;
            address.addProperty("fullyQualifiedName", addressSpace.getName());
            if (!(addressSpace instanceof OverlayAddressSpace)) continue;
            OverlayAddressSpace ospace = (OverlayAddressSpace)addressSpace;
            JsonObject artifact = new JsonObject();
            ploc.add("artifactLocation", (JsonElement)artifact);
            String name = ospace.getOverlayedSpace().getName();
            artifact.addProperty("uri", name);
        }
        return locations;
    }

    public static JsonArray setLocation(ghidra.program.model.address.Address addr, String kind, String uri, String name, String fqname, int index) {
        JsonArray locations = new JsonArray();
        JsonObject element = new JsonObject();
        locations.add((JsonElement)element);
        JsonObject ploc = new JsonObject();
        JsonArray lloc = new JsonArray();
        element.add("physicalLocation", (JsonElement)ploc);
        element.add("logicalLocations", (JsonElement)lloc);
        JsonObject artifact = new JsonObject();
        artifact.addProperty("uri", uri);
        JsonObject address = new JsonObject();
        ploc.add("artifactLocation", (JsonElement)artifact);
        ploc.add("address", (JsonElement)address);
        address.addProperty("absoluteAddress", (Number)addr.getOffset());
        if (name != null) {
            address.addProperty("name", name);
        }
        address.addProperty("kind", kind);
        address.addProperty("fullyQualifiedName", fqname);
        JsonObject ll = new JsonObject();
        lloc.add((JsonElement)ll);
        ll.addProperty("index", (Number)index);
        return locations;
    }

    public static AddressSet getLocations(Map<String, Object> result, Program program, AddressSet set) throws AddressOverflowException {
        List locations;
        if (set == null) {
            set = new AddressSet();
        }
        if ((locations = (List)result.get("Locations")) == null) {
            return set;
        }
        for (Location location : locations) {
            AddressRange range = SarifUtils.locationToRange(location, program);
            if (range == null) continue;
            set.add(range);
        }
        return set;
    }

    public static AddressRange locationToRange(Location location, Program program) throws AddressOverflowException {
        PhysicalLocation physicalLocation = location.getPhysicalLocation();
        long len = physicalLocation.getAddress().getLength();
        ghidra.program.model.address.Address addr = SarifUtils.locationToAddress(location, program, true);
        return addr == null ? null : new AddressRangeImpl(addr, len);
    }

    public static ghidra.program.model.address.Address locationToAddress(Location location, Program program, boolean useOverlays) {
        Long addr = -1L;
        PhysicalLocation physicalLocation = location.getPhysicalLocation();
        if (location.getPhysicalLocation() != null) {
            addr = physicalLocation.getAddress().getAbsoluteAddress();
        }
        if (addr >= 0L) {
            AddressFactory af = program.getAddressFactory();
            AddressSpace base = af.getDefaultAddressSpace();
            String fqn = physicalLocation.getAddress().getFullyQualifiedName();
            if (fqn == null) {
                return SarifUtils.longToAddress(base, addr);
            }
            if (fqn.equals("NO ADDRESS")) {
                return null;
            }
            ArtifactLocation artifact = physicalLocation.getArtifactLocation();
            if (artifact == null) {
                AddressSpace space = SarifUtils.getAddressSpace(program, fqn, base);
                return SarifUtils.longToAddress(space, addr);
            }
            String uri = artifact.getUri();
            base = program.getAddressFactory().getAddressSpace(uri);
            if (base == null) {
                if (!useOverlays) {
                    return SarifUtils.longToAddress(af.getDefaultAddressSpace(), addr);
                }
                try {
                    base = program.createOverlaySpace(fqn, base);
                }
                catch (LockException | InvalidNameException | DuplicateNameException | IllegalStateException e) {
                    throw new RuntimeException("Attempt to create " + fqn + " failed!");
                }
            }
            AddressSpace space = SarifUtils.getAddressSpace(program, fqn, base);
            return SarifUtils.longToAddress(space, addr);
        }
        if (location.getLogicalLocations() != null) {
            Set logicalLocations = location.getLogicalLocations();
            block14: for (LogicalLocation logLoc : logicalLocations) {
                if (logLoc.getKind() == null) {
                    logLoc = llocs[logLoc.getIndex().intValue()];
                }
                switch (logLoc.getKind()) {
                    case "function": {
                        String fname = logLoc.getName();
                        for (Function func : program.getFunctionManager().getFunctions(true)) {
                            if (!fname.equals(func.getName())) continue;
                            return func.getEntryPoint();
                        }
                        continue block14;
                    }
                    case "member": {
                        return SarifUtils.extractFQNameAddrPair(program, logLoc.getFullyQualifiedName()).get(0);
                    }
                    case "variable": {
                        return SarifUtils.extractFunctionEntryAddr(program, logLoc.getFullyQualifiedName());
                    }
                    case "instruction": {
                        break;
                    }
                    default: {
                        Msg.error((Object)program, (Object)("Unknown logical location to handle: " + logLoc.toString()));
                    }
                }
            }
        }
        return null;
    }

    private static AddressSpace getAddressSpace(Program program, String fqn, AddressSpace base) {
        AddressSpace space = program.getAddressFactory().getAddressSpace(fqn);
        if (space != null) {
            return space;
        }
        try {
            space = program.createOverlaySpace(fqn, base);
        }
        catch (LockException | InvalidNameException | DuplicateNameException | IllegalStateException e) {
            throw new RuntimeException("Attempt to create " + fqn + " failed!");
        }
        return space;
    }

    public static ghidra.program.model.address.Address longToAddress(AddressSpace space, Long addr) {
        return space.getAddressInThisSpaceOnly(addr.longValue());
    }

    public static ByteArrayInputStream getArtifactContent(Artifact artifact) {
        ArtifactContent content = artifact.getContents();
        String b64 = content.getBinary();
        byte[] decoded = Base64.decode((String)b64);
        return new ByteArrayInputStream(decoded);
    }

    public static ghidra.program.model.address.Address extractFunctionEntryAddr(Program program, String fqname) {
        String[] parts;
        String addr = null;
        if (fqname.contains("!") && !fqname.contains("!=")) {
            fqname = fqname.substring(0, fqname.indexOf("!"));
        }
        if ((parts = fqname.split("@")).length > 1) {
            String[] subparts = parts[1].split(":");
            if (subparts[0].equals("EXTERNAL")) {
                try {
                    addr = subparts[1];
                    return program.getAddressFactory().getAddressSpace(subparts[0]).getAddress(addr);
                }
                catch (AddressFormatException e) {
                    e.printStackTrace();
                }
            }
            addr = subparts[0];
        }
        return program.getAddressFactory().getAddress(addr);
    }

    public static List<ghidra.program.model.address.Address> extractFQNameAddrPair(Program program, String fqname) {
        ArrayList<ghidra.program.model.address.Address> addr_pair = new ArrayList<ghidra.program.model.address.Address>();
        String[] parts = fqname.split("@");
        if (parts.length > 1) {
            String[] subparts = parts[1].split(":");
            if (subparts.length > 1) {
                ghidra.program.model.address.Address faddress = program.getAddressFactory().getAddress(subparts[0]);
                addr_pair.add(faddress);
                ghidra.program.model.address.Address iaddress = program.getAddressFactory().getAddress(subparts[1]);
                addr_pair.add(iaddress != null ? iaddress : faddress);
            } else {
                if (parts[1].contains("!")) {
                    subparts = parts[1].split("!");
                }
                ghidra.program.model.address.Address faddress = program.getAddressFactory().getAddress(subparts[0]);
                addr_pair.add(faddress);
                addr_pair.add(faddress);
            }
        }
        return addr_pair;
    }

    public static String extractFQNameFunction(String fqname) {
        String fname = "UNKNOWN";
        String[] parts = fqname.split("@");
        if (parts.length > 0) {
            fname = parts[0];
        }
        return fname;
    }

    public static String extractDisplayName(LogicalLocation ll) {
        Object name = ll.getName();
        String fqname = ll.getFullyQualifiedName();
        name = name != null && ((String)name).startsWith("vn") ? fqname.split("@")[0] + ":" + fqname.split(":")[1] : fqname.split("@")[0] + ":" + (String)name;
        return name;
    }

    public static ReportingDescriptor getTaxaValue(ReportingDescriptorReference taxa, ToolComponent taxonomy) {
        ArrayList view = new ArrayList(taxonomy.getTaxa());
        return (ReportingDescriptor)view.get(taxa.getIndex().intValue());
    }

    public static ToolComponent getTaxonomy(ReportingDescriptorReference taxa, Set<ToolComponent> taxonomies) {
        Long idx = taxa.getToolComponent().getIndex();
        if (idx == null) {
            ArrayList<ToolComponent> view = new ArrayList<ToolComponent>(taxonomies);
            idx = taxa.getIndex();
            return (ToolComponent)view.get(idx instanceof Long ? idx.intValue() : ((Integer)((Object)idx)).intValue());
        }
        for (ToolComponent taxonomy : taxonomies) {
            if (!taxonomy.getName().equals(taxa.getToolComponent().getName())) continue;
            return taxonomy;
        }
        return null;
    }

    public static List<String> getTaxonomyNames(Run sarifRun) {
        ArrayList<String> names = new ArrayList<String>();
        Set taxonomies = sarifRun.getTaxonomies();
        if (taxonomies != null) {
            for (ToolComponent taxonomy : sarifRun.getTaxonomies()) {
                names.add(taxonomy.getName());
            }
        }
        return names;
    }

    public static LogicalLocation getLogicalLocation(Run run, Location loc) {
        if (!populating) {
            throw new RuntimeException("Locations valid only during population phase");
        }
        Set llocset = loc.getLogicalLocations();
        if (llocset == null) {
            return null;
        }
        Iterator it = llocset.iterator();
        if (it.hasNext()) {
            LogicalLocation next = (LogicalLocation)it.next();
            Long index = next.getIndex();
            if (index != null && llocs != null) {
                return llocs[index.intValue()];
            }
            return next;
        }
        return null;
    }

    public static void validateRun(Run run) {
        SarifUtils.initRun(run);
    }

    private static void initRun(Run run) {
        Set rgraphs;
        Set runLocs;
        edgeDescs.clear();
        edgeSrcs.clear();
        edgeDsts.clear();
        currentRun = run;
        addresses = run.getAddresses();
        if (addresses != null) {
            for (Address sarifAddr : addresses) {
                Long offset = sarifAddr.getAbsoluteAddress();
                String fqname = sarifAddr.getFullyQualifiedName();
                nameToOffset.put(fqname, offset);
            }
        }
        if ((runLocs = run.getLogicalLocations()) != null) {
            llocs = new LogicalLocation[runLocs.size()];
            runLocs.toArray(llocs);
        }
        if ((rgraphs = run.getGraphs()) != null) {
            for (Graph rg : rgraphs) {
                Set edges = rg.getEdges();
                for (Edge e : edges) {
                    String id = e.getId();
                    String src = e.getSourceNodeId();
                    String dst = e.getTargetNodeId();
                    String desc = e.getLabel().getText();
                    edgeSrcs.put(id, src);
                    edgeDsts.put(id, dst);
                    Set<String> set = edgeDescs.get(desc);
                    if (set == null) {
                        set = new HashSet<String>();
                        edgeDescs.put(desc, set);
                    }
                    set.add(id);
                }
                Set nodes = rg.getNodes();
                for (Node n : nodes) {
                    String id = n.getId();
                    Location loc = n.getLocation();
                    if (loc == null) continue;
                    Set logicalLocations = loc.getLogicalLocations();
                    LogicalLocation[] nodells = new LogicalLocation[logicalLocations.size()];
                    int i = 0;
                    for (LogicalLocation ll : logicalLocations) {
                        if (ll.getFullyQualifiedName() != null) {
                            nodells[i++] = ll;
                            continue;
                        }
                        nodells[i++] = llocs[ll.getIndex().intValue()];
                    }
                    nodeLocs.put(id, nodells);
                }
            }
        }
    }

    public static Set<String> getEdgeSet(String fqname) {
        return edgeDescs.get(fqname);
    }

    public static String getEdgeSource(String edgeId) {
        return edgeSrcs.get(edgeId);
    }

    public static String getEdgeDest(String edgeId) {
        return edgeDsts.get(edgeId);
    }

    public static ghidra.program.model.address.Address getLocAddress(Program program, String fqname) {
        Long offset = nameToOffset.get(fqname);
        if (offset == null) {
            return null;
        }
        return SarifUtils.getAddress(program, offset);
    }

    public static ghidra.program.model.address.Address getAddress(Program program, Long offset) {
        return program.getAddressFactory().getDefaultAddressSpace().getAddress(offset.longValue());
    }

    public static LogicalLocation[] getNodeLocs(String id) {
        return nodeLocs.get(id);
    }

    public static void setPopulating(boolean b) {
        populating = b;
    }

    public static Map<String, Set<String>> getEdgeMap() {
        return edgeDescs;
    }

    static {
        nameToOffset = new HashMap<String, Long>();
        nodeLocs = new HashMap<String, LogicalLocation[]>();
        edgeSrcs = new HashMap<String, String>();
        edgeDsts = new HashMap<String, String>();
        edgeDescs = new HashMap<String, Set<String>>();
        populating = false;
    }
}

