/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard.session;

import docking.wizard.WizardModel;
import docking.wizard.WizardStep;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.wizard.session.CreateNewSessionTask;
import ghidra.feature.vt.gui.wizard.session.NewSessionData;
import ghidra.feature.vt.gui.wizard.session.PreconditionsStep;
import ghidra.feature.vt.gui.wizard.session.SessionConfigurationStep;
import ghidra.feature.vt.gui.wizard.session.SummaryStep;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.util.List;

public class VTNewSessionWizardModel
extends WizardModel<NewSessionData> {
    private final VTController controller;

    public VTNewSessionWizardModel(VTController controller) {
        this(controller, null, null);
    }

    public VTNewSessionWizardModel(VTController controller, DomainFile sourceFile, DomainFile destinationFile) {
        super("New Version Tracking Session", (Object)new NewSessionData());
        this.controller = controller;
        PluginTool tool = controller.getTool();
        ((NewSessionData)this.data).setSourceFile(sourceFile, tool);
        ((NewSessionData)this.data).setDestinationFile(destinationFile, tool);
        DomainFolder folder = tool.getProject().getProjectData().getRootFolder();
        ((NewSessionData)this.data).setSessionFolder(folder);
    }

    protected void addWizardSteps(List<WizardStep<NewSessionData>> list) {
        list.add(new SessionConfigurationStep(this, this.controller.getTool()));
        list.add(new PreconditionsStep(this));
        list.add(new SummaryStep(this));
    }

    protected boolean doFinish() {
        CreateNewSessionTask task = new CreateNewSessionTask(this.controller, (NewSessionData)this.data);
        new TaskLauncher((Task)task, (Component)this.wizardDialog.getComponent());
        return true;
    }
}

