/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.spatial.rect;

import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.spatial.AbstractConstraintsTree;
import ghidra.util.database.spatial.AbstractConstraintsTreeSpatialMap;
import ghidra.util.database.spatial.AbstractRStarConstraintsTree;
import ghidra.util.database.spatial.BoundedShape;
import ghidra.util.database.spatial.DBTreeDataRecord;
import ghidra.util.database.spatial.DBTreeNodeRecord;
import ghidra.util.database.spatial.rect.AbstractRectangle2DQuery;
import ghidra.util.database.spatial.rect.EuclideanSpace2D;
import ghidra.util.database.spatial.rect.Rectangle2D;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;

public abstract class Abstract2DRStarTree<X, Y, DS extends BoundedShape<NS>, DR extends DBTreeDataRecord<DS, NS, T>, NS extends Rectangle2D<X, Y, NS>, NR extends DBTreeNodeRecord<NS>, T, Q extends AbstractRectangle2DQuery<X, Y, DS, NS, Q>>
extends AbstractRStarConstraintsTree<DS, DR, NS, NR, T, Q> {
    protected final EuclideanSpace2D<X, Y> space;
    protected final List<Comparator<NS>> axes;

    public Abstract2DRStarTree(DBCachedObjectStoreFactory storeFactory, String tableName, final EuclideanSpace2D<X, Y> space, Class<DR> dataType, Class<NR> nodeType, boolean upgradable, int maxChildren) throws VersionException, IOException {
        super(storeFactory, tableName, dataType, nodeType, upgradable, maxChildren);
        this.space = space;
        this.axes = List.of(new Comparator<NS>(){

            @Override
            public int compare(NS o1, NS o2) {
                return space.compareX(o1.getX1(), o2.getX1());
            }
        }, new Comparator<NS>(){

            @Override
            public int compare(NS o1, NS o2) {
                return space.compareY(o1.getY1(), o2.getY1());
            }
        });
    }

    @Override
    protected List<Comparator<NS>> getSplitAxes() {
        return this.axes;
    }

    @Override
    public AbstractConstraintsTreeSpatialMap<DS, DR, NS, T, Q> asSpatialMap() {
        return new AsSpatialMap(this, null);
    }

    public EuclideanSpace2D<X, Y> getShapeSpace() {
        return this.space;
    }

    protected static class AsSpatialMap<DS extends BoundedShape<NS>, DR extends DBTreeDataRecord<DS, NS, T>, NS extends Rectangle2D<?, ?, NS>, T, Q extends AbstractRectangle2DQuery<?, ?, DS, NS, Q>>
    extends AbstractConstraintsTreeSpatialMap<DS, DR, NS, T, Q> {
        public AsSpatialMap(AbstractConstraintsTree<DS, DR, NS, ?, T, Q> tree, Q query) {
            super(tree, query);
        }

        public AsSpatialMap<DS, DR, NS, T, Q> reduce(Q andQuery) {
            return new AsSpatialMap<DS, DR, NS, T, Q>(this.tree, this.query == null ? andQuery : ((AbstractRectangle2DQuery)this.query).and(andQuery));
        }
    }
}

