/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api;

import generic.lsh.KandL;
import generic.lsh.LSHMemoryModel;
import generic.lsh.Partition;
import generic.lsh.vector.HashEntry;
import ghidra.feature.vt.api.FunctionNode;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

class BinningSystem {
    private final int L;
    private int[][] partitionIdentities;
    private TreeMap<Integer, TreeSet<FunctionNode>>[] binSys;

    public BinningSystem(LSHMemoryModel model) {
        int k = model.getK();
        this.L = KandL.memoryModelToL((LSHMemoryModel)model);
        this.partitionIdentities = new int[this.L][];
        this.binSys = new TreeMap[this.L];
        Random random = new Random(23L);
        for (int ii = 0; ii < this.L; ++ii) {
            this.partitionIdentities[ii] = new int[k];
            for (int jj = 0; jj < k; ++jj) {
                this.partitionIdentities[ii][jj] = random.nextInt();
            }
            this.binSys[ii] = new TreeMap();
        }
    }

    public void add(Iterator<FunctionNode> iter, TaskMonitor monitor) throws CancelledException {
        while (iter.hasNext()) {
            FunctionNode node = iter.next();
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            if (node.getVector() == null) continue;
            int[] features = this.getBinIds(node);
            for (int ii = 0; ii < features.length; ++ii) {
                TreeSet<FunctionNode> list = this.binSys[ii].get(features[ii]);
                if (list == null) {
                    list = new TreeSet();
                    this.binSys[ii].put(features[ii], list);
                }
                list.add(node);
            }
        }
    }

    public Set<FunctionNode> lookup(FunctionNode node) {
        TreeSet<FunctionNode> result = new TreeSet<FunctionNode>();
        int[] features = this.getBinIds(node);
        for (int ii = 0; ii < features.length; ++ii) {
            TreeSet<FunctionNode> list = this.binSys[ii].get(features[ii]);
            if (list == null) continue;
            result.addAll(list);
        }
        return result;
    }

    private int[] getBinIds(FunctionNode node) {
        if (node.getVector() == null) {
            return null;
        }
        int[] result = new int[this.L];
        HashEntry[] entries = node.getVector().getEntries();
        for (int ii = 0; ii < this.L; ++ii) {
            int hash;
            result[ii] = hash = Partition.hash((int[])this.partitionIdentities[ii], (HashEntry[])entries);
        }
        return result;
    }
}

