/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.DebugHeader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;

public class RvaVaDebugHeader
extends DebugHeader {
    private long relativeVirtualAddressDataBase;
    private BigInteger virtualAddressImageBase;
    private long unsignedIntReserved1;
    private long unsignedIntReserved2;

    public long getRelativeVirtualAddressDataBase() {
        return this.relativeVirtualAddressDataBase;
    }

    public BigInteger getVirtualAddressImageBase() {
        return this.virtualAddressImageBase;
    }

    public long getReserved1() {
        return this.unsignedIntReserved1;
    }

    public long getReserved2() {
        return this.unsignedIntReserved2;
    }

    @Override
    public void deserialize(PdbByteReader reader) throws PdbException {
        super.deserialize(reader);
        this.relativeVirtualAddressDataBase = reader.parseUnsignedIntVal();
        this.virtualAddressImageBase = reader.parseUnsignedLongVal();
        this.unsignedIntReserved1 = reader.parseUnsignedIntVal();
        this.unsignedIntReserved2 = reader.parseUnsignedIntVal();
    }

    @Override
    protected void dumpInternal(Writer writer) throws IOException {
        super.dumpInternal(writer);
        writer.write(String.format("relativeVirtualAddressDataBase: 0X%08X\n", this.relativeVirtualAddressDataBase));
        writer.write(String.format("virtualAddressImageBase: 0X%016X\n", this.virtualAddressImageBase));
        writer.write(String.format("unsignedIntReserved1: 0X%08X\n", this.unsignedIntReserved1));
        writer.write(String.format("unsignedIntReserved2: 0X%08X\n", this.unsignedIntReserved2));
    }
}

