/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import ghidra.trace.database.symbol.AbstractDBTraceSymbol;
import ghidra.trace.database.symbol.DBTraceNamespaceSymbol;
import ghidra.trace.database.symbol.DBTraceSymbolManager;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.util.LockHold;
import ghidra.util.UserSearchUtils;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractDBTraceSymbolSingleTypeView<T extends AbstractDBTraceSymbol> {
    protected final DBTraceSymbolManager manager;
    protected final byte typeID;
    protected final DBCachedObjectStore<T> store;
    protected final Collection<T> view;
    protected final DBCachedObjectIndex<Long, T> symbolsByParentID;
    protected final DBCachedObjectIndex<String, T> symbolsByName;

    public AbstractDBTraceSymbolSingleTypeView(DBTraceSymbolManager manager, byte typeID, DBCachedObjectStore<T> store) {
        this.manager = manager;
        this.typeID = typeID;
        this.store = store;
        this.view = this.constructView();
        this.symbolsByParentID = store.getIndex(Long.TYPE, AbstractDBTraceSymbol.PARENT_COLUMN);
        this.symbolsByName = store.getIndex(String.class, AbstractDBTraceSymbol.NAME_COLUMN);
    }

    protected Collection<T> constructView() {
        return Collections.unmodifiableCollection(this.store.asMap().values());
    }

    public DBTraceSymbolManager getManager() {
        return this.manager;
    }

    public Collection<? extends T> getAll(boolean includeDynamicSymbols) {
        return this.view;
    }

    public Collection<? extends T> getChildrenNamed(String name, TraceNamespaceSymbol parent) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            DBTraceNamespaceSymbol dbnsParent = this.manager.assertIsMine(Objects.requireNonNull(parent));
            Collection collection = this.symbolsByParentID.get((Object)dbnsParent.getID()).stream().filter(s -> name.equals(s.name)).collect(Collectors.toUnmodifiableList());
            return collection;
        }
    }

    public Collection<? extends T> getChildren(TraceNamespaceSymbol parent) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            DBTraceNamespaceSymbol dbnsParent = this.manager.assertIsMine(parent);
            Collection collection = Collections.unmodifiableCollection(this.symbolsByParentID.get((Object)dbnsParent.getID()));
            return collection;
        }
    }

    public Collection<? extends T> getNamed(String name) {
        return Collections.unmodifiableCollection(this.symbolsByName.get((Object)name));
    }

    public Collection<? extends T> getWithMatchingName(String glob, boolean caseSensitive) {
        Predicate<String> predicate = UserSearchUtils.createSearchPattern((String)glob, (boolean)caseSensitive).asPredicate();
        return this.view.stream().filter(s -> predicate.test(s.name)).toList();
    }

    public Iterator<? extends T> scanByName(String startName) {
        return this.symbolsByName.tail((Object)startName, true).values().iterator();
    }

    public T getByKey(long key) {
        return (T)((AbstractDBTraceSymbol)this.store.getObjectAt(key));
    }

    public void invalidateCache() {
        this.store.invalidateCache();
    }
}

