/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.lifecycle.Unfinished;
import ghidra.pcode.emu.jit.analysis.JitAllocationModel;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.IntBinOpGen;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.op.JitIntSubOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public enum IntSubOpGen implements IntBinOpGen<JitIntSubOp>
{
    GEN;


    @Override
    public boolean isSigned() {
        return false;
    }

    private void generateMpIntLegSub(JitCodeGenerator gen, int idx, boolean takesBorrow, boolean givesBorrow, MethodVisitor mv) {
        if (takesBorrow) {
            mv.visitLdcInsn((Object)32);
            mv.visitInsn(123);
            mv.visitInsn(93);
            mv.visitInsn(88);
            TypeConversions.generateIntToLong(JitType.IntJitType.I4, JitType.LongJitType.I8, TypeConversions.Ext.ZERO, mv);
            mv.visitInsn(97);
        } else {
            TypeConversions.generateIntToLong(JitType.IntJitType.I4, JitType.LongJitType.I8, TypeConversions.Ext.ZERO, mv);
        }
        mv.visitVarInsn(21, idx);
        TypeConversions.generateIntToLong(JitType.IntJitType.I4, JitType.LongJitType.I8, TypeConversions.Ext.ZERO, mv);
        mv.visitInsn(101);
        if (givesBorrow) {
            mv.visitInsn(92);
        }
        TypeConversions.generateLongToInt(JitType.LongJitType.I8, JitType.IntJitType.I4, TypeConversions.Ext.ZERO, mv);
        mv.visitVarInsn(54, idx);
    }

    private void generateMpIntSub(JitCodeGenerator gen, JitType.MpIntJitType type, MethodVisitor mv) {
        int legCount = type.legsAlloc();
        try (JitAllocationModel.JvmTempAlloc result = gen.getAllocationModel().allocateTemp(mv, "result", legCount);){
            OpGen.generateMpLegsIntoTemp(result, legCount, mv);
            for (int i = 0; i < legCount; ++i) {
                boolean isLast = i == legCount - 1;
                boolean takesCarry = i != 0;
                this.generateMpIntLegSub(gen, result.idx(i), takesCarry, !isLast, mv);
            }
            OpGen.generateMpLegsFromTemp(result, legCount, mv);
        }
    }

    @Override
    public JitType afterLeft(JitCodeGenerator gen, JitIntSubOp op, JitType lType, JitType rType, MethodVisitor rv) {
        return TypeConversions.forceUniform(gen, lType, rType, TypeConversions.Ext.ZERO, rv);
    }

    @Override
    public JitType generateBinOpRunCode(JitCodeGenerator gen, JitIntSubOp op, JitControlFlowModel.JitBlock block, JitType lType, JitType rType, MethodVisitor rv) {
        JitType jitType = rType = TypeConversions.forceUniform(gen, rType, lType, TypeConversions.Ext.ZERO, rv);
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.MpIntJitType.class, JitType.MpIntJitType.class}, (Object)jitType2, n)) {
                case 0: {
                    JitType.IntJitType t = (JitType.IntJitType)jitType2;
                    rv.visitInsn(100);
                    break block6;
                }
                case 1: {
                    JitType.LongJitType t = (JitType.LongJitType)jitType2;
                    rv.visitInsn(101);
                    break block6;
                }
                case 2: {
                    JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                    if (t.size() != lType.size()) {
                        n = 3;
                        continue block6;
                    }
                    this.generateMpIntSub(gen, t, rv);
                    break block6;
                }
                case 3: {
                    JitType.MpIntJitType t = (JitType.MpIntJitType)jitType2;
                    Unfinished.TODO((String)"MpInt of differing sizes", (Object[])new Object[0]);
                    break block6;
                }
                default: {
                    throw new AssertionError();
                }
            }
            break;
        }
        return rType;
    }
}

