/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server.store;

import db.buffers.LocalManagedBufferFile;
import ghidra.framework.remote.RepositoryItem;
import ghidra.framework.remote.User;
import ghidra.framework.store.CheckoutType;
import ghidra.framework.store.DatabaseItem;
import ghidra.framework.store.ItemCheckoutStatus;
import ghidra.framework.store.TextDataItem;
import ghidra.framework.store.Version;
import ghidra.framework.store.local.LocalDatabaseItem;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.framework.store.local.LocalFolderItem;
import ghidra.server.Repository;
import ghidra.server.RepositoryManager;
import ghidra.server.store.RepositoryFolder;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.UserAccessException;
import java.io.FileNotFoundException;
import java.io.IOException;

public class RepositoryFile {
    private Repository repository;
    private LocalFileSystem fileSystem;
    private RepositoryFolder parent;
    private String name;
    private LocalFolderItem folderItem;
    private RepositoryItem repositoryItem;
    private boolean deleted = false;

    RepositoryFile(Repository repository, LocalFileSystem fileSystem, RepositoryFolder parent, String name) {
        this.repository = repository;
        this.fileSystem = fileSystem;
        this.parent = parent;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.repository.validate();
            if (this.deleted) {
                throw new FileNotFoundException(this.getPathname() + " not found");
            }
            if (this.folderItem == null) {
                this.repositoryItem = null;
                this.folderItem = this.fileSystem.getItem(this.parent.getPathname(), this.name);
                if (this.folderItem == null) {
                    Object pathname = this.parent.getPathname();
                    if (((String)pathname).length() != 1) {
                        pathname = (String)pathname + "/";
                    }
                    pathname = (String)pathname + this.name;
                    RepositoryManager.log(this.repository.getName(), (String)pathname, "file is corrupt or unsupported", null);
                    throw new FileNotFoundException((String)pathname + " is corrupt or unsupported");
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public RepositoryFolder getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPathname() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            String parentPath = this.parent.getPathname();
            if (parentPath.length() == 1) {
                return parentPath + this.name;
            }
            return parentPath + "/" + this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryItem getItem() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                this.validate();
                if (this.repositoryItem == null && this.folderItem != null) {
                    String textData = null;
                    int itemType = -1;
                    if (this.folderItem instanceof DatabaseItem) {
                        itemType = 2;
                    } else {
                        LocalFolderItem localFolderItem = this.folderItem;
                        if (localFolderItem instanceof TextDataItem) {
                            TextDataItem textItem = (TextDataItem)localFolderItem;
                            itemType = 3;
                            textData = textItem.getTextData();
                        } else {
                            this.repository.log(this.getPathname(), "Unsupported item type: " + this.folderItem.getClass().getSimpleName(), null);
                        }
                    }
                    this.repositoryItem = new RepositoryItem(this.parent.getPathname(), this.name, this.folderItem.getFileID(), itemType, this.folderItem.getContentType(), this.folderItem.getCurrentVersion(), this.folderItem.lastModified(), textData);
                }
            }
            catch (IOException e) {
                this.repository.log(this.getPathname(), "Item failure: " + e.getMessage(), null);
            }
            if (this.repository == null) {
                this.repositoryItem = new RepositoryItem(this.parent.getPathname(), this.name, null, 1, "INVALID", 0, 0L, null);
            }
            return this.repositoryItem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalManagedBufferFile openDatabase(int version, int minChangeDataVer, String user) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.validate();
            this.repository.validateReadPrivilege(user);
            LocalFolderItem localFolderItem = this.folderItem;
            if (!(localFolderItem instanceof LocalDatabaseItem)) {
                throw new IOException("Unsupported operation for " + this.folderItem.getClass().getSimpleName());
            }
            LocalDatabaseItem databaseItem = (LocalDatabaseItem)localFolderItem;
            LocalManagedBufferFile bf = databaseItem.open(version, minChangeDataVer);
            this.repository.log(this.getPathname(), "version " + (version < 0 ? this.folderItem.getCurrentVersion() : version) + " opened read-only", user);
            return bf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalManagedBufferFile openDatabase(long checkoutId, String user) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.validate();
            this.repository.validateWritePrivilege(user);
            LocalFolderItem localFolderItem = this.folderItem;
            if (!(localFolderItem instanceof LocalDatabaseItem)) {
                throw new IOException("Unsupported operation for " + this.folderItem.getClass().getSimpleName());
            }
            LocalDatabaseItem databaseItem = (LocalDatabaseItem)localFolderItem;
            ItemCheckoutStatus coStatus = this.folderItem.getCheckout(checkoutId);
            if (coStatus == null) {
                throw new IOException("Illegal checkin");
            }
            if (!coStatus.getUser().equals(user)) {
                throw new IOException("Checkin not permitted, checkout was made by " + coStatus.getUser());
            }
            LocalManagedBufferFile bf = databaseItem.openForUpdate(checkoutId);
            this.repository.log(this.getPathname(), "check-in started", user);
            return bf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Version[] getVersions(String user) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.validate();
            this.repository.validateReadPrivilege(user);
            return this.folderItem.getVersions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.validate();
            return this.folderItem.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int deleteVersion, String user) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.validate();
            User userObj = this.repository.validateWritePrivilege(user);
            if (!userObj.isAdmin()) {
                Version[] versions = this.folderItem.getVersions();
                if (deleteVersion == -1) {
                    for (Version version : versions) {
                        if (user.equals(version.getUser())) continue;
                        throw new UserAccessException(this.getName() + " version " + version.getVersion() + " owned by " + version.getUser());
                    }
                } else if (deleteVersion == versions[0].getVersion()) {
                    if (!user.equals(versions[0].getUser())) {
                        throw new UserAccessException(this.getName() + " version " + deleteVersion + " owned by " + versions[0].getUser());
                    }
                } else if (deleteVersion == versions[versions.length - 1].getVersion()) {
                    if (!user.equals(versions[versions.length - 1].getUser())) {
                        throw new UserAccessException(this.getName() + " version " + deleteVersion + " owned by " + versions[versions.length - 1].getUser());
                    }
                } else {
                    throw new IOException("Only the oldest or latest version may be deleted");
                }
            }
            if (this.folderItem != null) {
                this.folderItem.delete(deleteVersion, user);
            }
            this.deleted = true;
            this.repositoryItem = null;
            this.parent.fileDeleted(this);
            this.parent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTo(RepositoryFolder newParent, String newItemName, String user) throws InvalidNameException, IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.validate();
            this.repository.validateWritePrivilege(user);
            String oldName = this.name;
            String oldPath = this.getPathname();
            String newFolderPath = newParent.getPathname();
            this.fileSystem.moveItem(this.parent.getPathname(), this.getName(), newFolderPath, newItemName);
            this.name = newItemName;
            this.parent.fileMoved(this, oldName, newParent);
            this.parent = newParent;
            this.pathChanged();
            RepositoryManager.log(this.repository.getName(), oldPath, "file moved to " + this.getPathname(), user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemCheckoutStatus checkout(CheckoutType checkoutType, String user, String projectPath) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.validate();
            this.repository.validateWritePrivilege(user);
            ItemCheckoutStatus coStatus = this.folderItem.checkout(checkoutType, user, projectPath);
            if (coStatus != null && checkoutType != CheckoutType.NORMAL && this.repositoryItem != null && this.repositoryItem.getFileID() == null) {
                this.repositoryItem = null;
            }
            return coStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCheckoutVersion(long checkoutId, int checkoutVersion, String user) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.validate();
            this.folderItem.updateCheckoutVersion(checkoutId, checkoutVersion, user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateCheckout(long checkoutId, String user, boolean notify) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.validate();
            ItemCheckoutStatus coStatus = this.folderItem.getCheckout(checkoutId);
            if (coStatus != null) {
                User userObj = this.repository.getUser(user);
                if (!userObj.isAdmin() && !coStatus.getUser().equals(user)) {
                    throw new IOException("Undo-checkout not permitted, checkout was made by " + coStatus.getUser());
                }
                this.folderItem.terminateCheckout(checkoutId, notify);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemCheckoutStatus getCheckout(long checkoutId, String user) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.validate();
            this.repository.validateReadPrivilege(user);
            return this.folderItem.getCheckout(checkoutId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemCheckoutStatus[] getCheckouts(String user) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.validate();
            this.repository.validateReadPrivilege(user);
            return this.folderItem.getCheckouts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCheckouts() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.validate();
            return this.folderItem.hasCheckouts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCheckinActive() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.validate();
            return this.folderItem.isCheckinActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemChanged() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.repositoryItem = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pathChanged() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            this.repositoryItem = null;
            this.folderItem = null;
        }
    }
}

