/*
 * Decompiled with CFR 0.152.
 */
package ghidra.debug.api.action;

import ghidra.debug.api.action.LocationTrackingSpec;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import java.util.Map;
import java.util.function.Function;

public class InstanceUtils {
    public static <T> void collectUniqueInstances(Class<T> cls, Map<String, T> map, Function<T, String> keyFunc) {
        for (Object t : ClassSearcher.getInstances(cls)) {
            String key = keyFunc.apply(t);
            T exists = map.get(key);
            if (exists != null) {
                if (exists.getClass().equals(t.getClass())) continue;
                Msg.error(LocationTrackingSpec.class, (Object)(cls.getSimpleName() + " conflict over key: " + key));
            }
            map.put(key, t);
        }
    }
}

