/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.dmgextractor.io;

import java.io.IOException;
import java.io.InputStream;

public class ByteCountInputStream
extends InputStream {
    private long bytePos = 0L;
    private InputStream is;

    public ByteCountInputStream(InputStream is) {
        this.is = is;
    }

    public long getBytesRead() {
        return this.bytePos;
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public void close() throws IOException {
        this.is.close();
    }

    public void mark(int readLimit) {
        throw new RuntimeException("Mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int res = this.is.read();
        if (res > 0) {
            ++this.bytePos;
        }
        return res;
    }

    public int read(byte[] b) throws IOException {
        int res = this.is.read(b);
        if (res > 0) {
            this.bytePos += (long)res;
        }
        return res;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int res = this.is.read(b, off, len);
        if (res > 0) {
            this.bytePos += (long)res;
        }
        return res;
    }

    public void reset() throws IOException {
        throw new RuntimeException("Mark/reset not supported");
    }

    public long skip(long n) throws IOException {
        System.out.println("skip(" + n + ");");
        long res = this.is.skip(n);
        if (res > 0L) {
            this.bytePos += res;
        }
        return res;
    }
}

