/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.util.job;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.util.Caching;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedFunctionGraphVertex;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphOptions;
import ghidra.app.plugin.core.functiongraph.util.job.AbstractFunctionGraphTransitionJob;
import ghidra.graph.viewer.layout.LayoutPositions;
import ghidra.graph.viewer.options.RelayoutOption;
import ghidra.program.model.address.Address;
import ghidra.util.exception.AssertException;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractGroupingFunctionGraphJob
extends AbstractFunctionGraphTransitionJob {
    protected final GroupedFunctionGraphVertex groupVertex;
    protected Set<FGVertex> verticesToBeRemoved;
    protected Set<FGVertex> newVertices;
    protected final boolean relayout;

    protected static Set<FGVertex> asSet(GroupedFunctionGraphVertex groupVertex) {
        HashSet<FGVertex> set = new HashSet<FGVertex>();
        set.add(groupVertex);
        return set;
    }

    AbstractGroupingFunctionGraphJob(FGController controller, GroupedFunctionGraphVertex groupVertex, Set<FGVertex> newVertices, Set<FGVertex> verticesToRemove, boolean relayoutOverride, boolean useAnimation) {
        super(controller, useAnimation);
        FunctionGraphOptions options;
        RelayoutOption relayoutOption;
        this.controller = controller;
        this.groupVertex = groupVertex;
        this.newVertices = new HashSet<FGVertex>(newVertices);
        this.verticesToBeRemoved = new HashSet<FGVertex>(verticesToRemove);
        this.updateOpacity(0.0);
        if (this.graph.getVertexCount() >= 125) {
            this.useAnimation = false;
        }
        this.relayout = (relayoutOption = (options = controller.getFunctionGraphOptions()).getRelayoutOption()) == RelayoutOption.VERTEX_GROUPING_CHANGES || relayoutOption == RelayoutOption.ALWAYS || relayoutOverride;
    }

    protected void finished() {
        super.finished();
        this.notifyGroupChange();
        this.removeOldVertexAndEdges();
        PickedState pickedVertexState = this.viewer.getPickedVertexState();
        pickedVertexState.clear();
        for (FGVertex vertex : this.getNewVertices()) {
            pickedVertexState.pick((Object)vertex, true);
        }
        this.getVerticesToBeRemoved().clear();
        this.getNewVertices().clear();
    }

    protected abstract void notifyGroupChange();

    protected LayoutPositions<FGVertex, FGEdge> updateDestinationLocations() {
        Point2D groupDestinationPoint;
        LayoutPositions positions;
        HashSet<FGVertex> ignore = new HashSet<FGVertex>();
        ignore.addAll(this.getVerticesToBeRemoved());
        if (this.relayout) {
            positions = this.calculateDefaultLayoutLocations(ignore);
            Map locations = positions.getVertexLocations();
            groupDestinationPoint = this.maybeGetGroupDestinationPoint(locations);
            if (groupDestinationPoint != null) {
                locations.put(this.groupVertex, groupDestinationPoint);
            }
        } else {
            positions = this.getCurrentLayoutLocations();
            Map currentLocations = positions.getVertexLocations();
            positions = LayoutPositions.createNewPositions((Map)currentLocations, new HashMap());
        }
        Map layoutLocations = positions.getVertexLocations();
        groupDestinationPoint = (Point2D)layoutLocations.get(this.groupVertex);
        Map<FGVertex, Point2D> groupingDestinationLocations = this.getGroupingDestinationLocations(this.relayout, groupDestinationPoint);
        Set<Map.Entry<FGVertex, Point2D>> entrySet = groupingDestinationLocations.entrySet();
        for (Map.Entry<FGVertex, Point2D> entry : entrySet) {
            FGVertex vertex = entry.getKey();
            Point2D location = entry.getValue();
            layoutLocations.put(vertex, location);
        }
        return positions;
    }

    protected abstract Map<FGVertex, Point2D> getGroupingDestinationLocations(boolean var1, Point2D var2);

    protected Collection<FGVertex> getVerticesToMove() {
        Collection graphVertices = this.graph.getVertices();
        if (this.relayout) {
            return new HashSet<FGVertex>(graphVertices);
        }
        HashSet<FGVertex> set = new HashSet<FGVertex>(this.groupVertex.getVertices());
        set.retainAll(graphVertices);
        return set;
    }

    protected Set<FGVertex> getVerticesToBeRemoved() {
        return this.verticesToBeRemoved;
    }

    protected Set<FGVertex> getNewVertices() {
        return this.newVertices;
    }

    protected void updateOpacity(double percentComplete) {
        double oldComponentsAlpha = 1.0 - percentComplete;
        Set<FGVertex> vertices = this.getVerticesToBeRemoved();
        for (FGVertex vertex : vertices) {
            vertex.setAlpha(oldComponentsAlpha);
            Collection edges = this.getEdges(vertex);
            for (FGEdge edge : edges) {
                double defaultAlpha = edge.getDefaultAlpha();
                double alpha = Math.min(oldComponentsAlpha, defaultAlpha);
                edge.setAlpha(alpha);
            }
        }
        double newComponentsAlpha = percentComplete;
        vertices = this.getNewVertices();
        for (FGVertex vertex : vertices) {
            vertex.setAlpha(newComponentsAlpha);
            Collection edges = this.getEdges(vertex);
            for (FGEdge edge : edges) {
                double defaultAlpha = edge.getDefaultAlpha();
                double alpha = Math.min(newComponentsAlpha, defaultAlpha);
                edge.setAlpha(alpha);
            }
        }
    }

    protected void clearLocationCache() {
        Layout jungLayout = this.viewer.getGraphLayout();
        ((Caching)jungLayout).clear();
    }

    private void removeOldVertexAndEdges() {
        Set<FGVertex> vertices = this.getVerticesToBeRemoved();
        this.graph.removeVertices(vertices);
    }

    private Point2D maybeGetGroupDestinationPoint(Map<FGVertex, Point2D> locations) {
        Set<FGVertex> toBeRemoved = this.getVerticesToBeRemoved();
        if (!toBeRemoved.contains(this.groupVertex)) {
            return null;
        }
        Address vertexAddress = this.groupVertex.getVertexAddress();
        Set<FGVertex> vertices = this.groupVertex.getVertices();
        for (FGVertex vertex : vertices) {
            if (!vertex.containsAddress(vertexAddress)) continue;
            Set<FGVertex> centerOverVertices = this.getNewVertices();
            return locations.get(centerOverVertices.iterator().next());
        }
        throw new AssertException("How did we not have a grouped vertex with the same address as the group vertex?");
    }
}

