/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.search;

import generic.concurrent.QCallback;
import generic.json.Json;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.PrettyPrinter;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.decompiler.parallel.DecompileConfigurer;
import ghidra.app.decompiler.parallel.DecompilerCallback;
import ghidra.app.decompiler.parallel.ParallelDecompiler;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferenceContext;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferenceContextBuilder;
import ghidra.app.plugin.core.search.TextMatch;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import utility.function.Dummy;

public class DecompilerTextFinder {
    public void findText(Program program, Pattern searchPattern, Consumer<TextMatch> consumer, TaskMonitor monitor) {
        monitor = TaskMonitor.dummyIfNull((TaskMonitor)monitor);
        StringFinderCallback callback = new StringFinderCallback(program, searchPattern, consumer);
        Listing listing = program.getListing();
        FunctionIterator functions = listing.getFunctions(true);
        this.doFindText(program, (Iterator<Function>)functions, callback, monitor);
    }

    public void findText(Program program, Pattern searchPattern, Iterator<Function> functions, Consumer<TextMatch> consumer, TaskMonitor monitor) {
        monitor = TaskMonitor.dummyIfNull((TaskMonitor)monitor);
        StringFinderCallback callback = new StringFinderCallback(program, searchPattern, consumer);
        this.doFindText(program, functions, callback, monitor);
    }

    public void findText(Program program, Pattern searchPattern, Collection<Function> functions, Consumer<TextMatch> consumer, TaskMonitor monitor) {
        monitor = TaskMonitor.dummyIfNull((TaskMonitor)monitor);
        StringFinderCallback callback = new StringFinderCallback(program, searchPattern, consumer);
        this.doFindText(functions, callback, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFindText(Collection<Function> functions, StringFinderCallback callback, TaskMonitor monitor) {
        try {
            ParallelDecompiler.decompileFunctions((QCallback)callback, functions, (TaskMonitor)monitor);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (!monitor.isCancelled()) {
                Msg.debug((Object)this, (Object)"Interrupted while decompiling functions");
            }
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"Encountered an exception decompiling functions", (Throwable)e);
        }
        finally {
            callback.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFindText(Program program, Iterator<Function> functions, StringFinderCallback callback, TaskMonitor monitor) {
        Consumer dummy = Dummy.consumer();
        try {
            ParallelDecompiler.decompileFunctions((QCallback)callback, (Program)program, functions, (Consumer)dummy, (TaskMonitor)monitor);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (!monitor.isCancelled()) {
                Msg.debug((Object)this, (Object)"Interrupted while decompiling functions");
            }
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"Encountered an exception decompiling functions", (Throwable)e);
        }
        finally {
            callback.dispose();
        }
    }

    private static class StringFinderCallback
    extends DecompilerCallback<Void> {
        private Consumer<TextMatch> callback;
        private Pattern pattern;
        private String searchText;

        StringFinderCallback(Program program, Pattern pattern, Consumer<TextMatch> callback) {
            super(program, (DecompileConfigurer)new DecompilerConfigurer());
            this.pattern = pattern;
            this.callback = callback;
            this.searchText = pattern.pattern();
        }

        public Void process(DecompileResults results, TaskMonitor monitor) throws Exception {
            boolean multiLine;
            Function function = results.getFunction();
            if (function.isThunk()) {
                return null;
            }
            ClangTokenGroup tokens = results.getCCodeMarkup();
            if (tokens == null) {
                return null;
            }
            List lines = DecompilerUtils.toLines((ClangTokenGroup)tokens);
            boolean bl = multiLine = (this.pattern.flags() & 0x20) == 32;
            if (multiLine) {
                this.performMultiLineSearch(function, lines);
            } else {
                for (ClangLine cLine : lines) {
                    this.findMatch(function, cLine);
                }
            }
            return null;
        }

        private void performMultiLineSearch(Function function, List<ClangLine> lines) {
            StringBuilder buffy = new StringBuilder();
            TreeMap<Integer, TextLine> linesRangeMap = new TreeMap<Integer, TextLine>();
            int pos = 0;
            for (ClangLine cLine : lines) {
                String text = PrettyPrinter.getText((ClangLine)cLine);
                buffy.append(text).append('\n');
                TextLine textLine = new TextLine(this, pos, cLine, text);
                linesRangeMap.put(pos, textLine);
                pos += text.length() + 1;
            }
            Matcher matcher = this.pattern.matcher(buffy);
            this.findMatches(function, linesRangeMap, matcher);
        }

        private void findMatches(Function function, TreeMap<Integer, TextLine> linesRangeMap, Matcher matcher) {
            while (matcher.find()) {
                this.emitTextMatch(function, linesRangeMap, matcher);
            }
        }

        private void emitTextMatch(Function function, TreeMap<Integer, TextLine> linesRangeMap, Matcher matcher) {
            ArrayList<TextLine> lineMatches = new ArrayList<TextLine>();
            int pos = 0;
            int start = matcher.start();
            int end = matcher.end();
            for (pos = start; pos < end; ++pos) {
                TextLine line = linesRangeMap.floorEntry(pos).getValue();
                int lineStartOffset = start - line.getOffset();
                if (lineStartOffset >= 0) {
                    line.setMatchStart(lineStartOffset);
                }
                if (end <= line.getEndOffset()) {
                    int relativeEnd = end - line.getOffset();
                    line.setMatchEnd(relativeEnd);
                }
                lineMatches.add(line);
                pos = line.getEndOffset();
            }
            TextLine firstLine = (TextLine)lineMatches.get(0);
            int lineNumber = firstLine.getLineNumber();
            AddressSet addresses = this.getAddresses(function, firstLine.getCLine());
            LocationReferenceContext context = this.createMatchContext(lineMatches);
            TextMatch match = new TextMatch(function, addresses, lineNumber, this.searchText, context, true);
            this.callback.accept(match);
        }

        private LocationReferenceContext createMatchContext(List<TextLine> matches) {
            LocationReferenceContextBuilder builder = new LocationReferenceContextBuilder();
            for (TextLine line : matches) {
                if (!builder.isEmpty()) {
                    builder.newline();
                }
                String text = line.getText();
                int start = line.getMatchStart();
                int end = line.getMatchEnd();
                builder.append(text.substring(0, start));
                builder.appendMatch(text.substring(start, end));
                builder.append(text.substring(end, line.length()));
            }
            return builder.build();
        }

        private void findMatch(Function function, ClangLine line) {
            String textLine = PrettyPrinter.getText((ClangLine)line);
            Matcher matcher = this.pattern.matcher(textLine);
            if (!matcher.find()) {
                return;
            }
            LocationReferenceContextBuilder builder = new LocationReferenceContextBuilder();
            int start = matcher.start();
            int end = matcher.end();
            builder.append(textLine.substring(0, start));
            builder.appendMatch(textLine.substring(start, end));
            if (end < textLine.length()) {
                builder.append(textLine.substring(end));
            }
            int lineNumber = line.getLineNumber();
            AddressSet addresses = this.getAddresses(function, line);
            LocationReferenceContext context = builder.build();
            TextMatch match = new TextMatch(function, addresses, lineNumber, this.searchText, context, false);
            this.callback.accept(match);
        }

        private AddressSet getAddresses(Function function, ClangLine line) {
            Program program = function.getProgram();
            AddressSpace space = function.getEntryPoint().getAddressSpace();
            List tokens = line.getAllTokens();
            return DecompilerUtils.findClosestAddressSet((Program)program, (AddressSpace)space, (List)tokens);
        }

        private class TextLine {
            private ClangLine cLine;
            private int offset;
            private String text;
            private int matchStart;
            private int matchEnd;

            TextLine(StringFinderCallback stringFinderCallback, int offset, ClangLine cLine, String text) {
                this.cLine = cLine;
                this.offset = offset;
                this.text = text;
                this.matchStart = 0;
                this.matchEnd = text.length();
            }

            ClangLine getCLine() {
                return this.cLine;
            }

            int length() {
                return this.text.length();
            }

            int getOffset() {
                return this.offset;
            }

            int getEndOffset() {
                return this.offset + this.length();
            }

            int getLineNumber() {
                return this.cLine.getLineNumber();
            }

            String getText() {
                return this.text;
            }

            int getMatchStart() {
                return this.matchStart;
            }

            int getMatchEnd() {
                return this.matchEnd;
            }

            void setMatchStart(int matchStart) {
                this.matchStart = matchStart;
            }

            void setMatchEnd(int matchEnd) {
                this.matchEnd = matchEnd;
            }

            public String toString() {
                return Json.toString((Object)this);
            }
        }
    }

    private static class DecompilerConfigurer
    implements DecompileConfigurer {
        private DecompilerConfigurer() {
        }

        public void configure(DecompInterface decompiler) {
            decompiler.toggleCCode(true);
            decompiler.toggleSyntaxTree(true);
            decompiler.setSimplificationStyle("decompile");
            DecompileOptions xmlOptions = new DecompileOptions();
            xmlOptions.setDefaultTimeout(60);
            decompiler.setOptions(xmlOptions);
        }
    }
}

