/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.register;

import docking.ComponentProvider;
import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.gui.register.DebuggerRegistersProvider;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.MarkerService;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.Register;
import ghidra.program.util.DefaultLanguageService;
import ghidra.trace.model.Trace;
import ghidra.util.Msg;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jdom.Element;

@PluginInfo(shortDescription="Debugger registers manager", description="GUI to view and modify register values", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceActivatedPluginEvent.class, TraceClosedPluginEvent.class}, servicesRequired={DebuggerTraceManagerService.class, MarkerService.class, DataTypeManagerService.class})
public class DebuggerRegistersPlugin
extends AbstractDebuggerPlugin {
    private static final String KEY_SELECTION_BY_CSPEC = "selectionByCSpec";
    private static final String KEY_FAVORITES_BY_CSPEC = "favoritesByCSpec";
    private static final String KEY_DISCONNECTED_COUNT = "disconnectedCount";
    private static final String PREFIX_DISCONNECTED_PROVIDER = "disconnectedProvider";
    protected DebuggerRegistersProvider connectedProvider;
    private final Map<LanguageCompilerSpecPair, LinkedHashSet<Register>> selectionByCSpec = new HashMap<LanguageCompilerSpecPair, LinkedHashSet<Register>>();
    private final Map<LanguageCompilerSpecPair, LinkedHashSet<Register>> favoritesByCSpec = new HashMap<LanguageCompilerSpecPair, LinkedHashSet<Register>>();
    private final Set<DebuggerRegistersProvider> disconnectedProviders = new HashSet<DebuggerRegistersProvider>();

    public DebuggerRegistersPlugin(PluginTool tool) {
        super(tool);
    }

    @Override
    protected void init() {
        this.connectedProvider = this.createProvider(false);
        super.init();
    }

    protected DebuggerRegistersProvider createProvider(boolean isClone) {
        return new DebuggerRegistersProvider(this, this.selectionByCSpec, this.favoritesByCSpec, isClone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DebuggerRegistersProvider createNewDisconnectedProvider() {
        DebuggerRegistersProvider p = this.createProvider(true);
        Set<DebuggerRegistersProvider> set = this.disconnectedProviders;
        synchronized (set) {
            this.disconnectedProviders.add(p);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void providerRemoved(DebuggerRegistersProvider p) {
        Set<DebuggerRegistersProvider> set = this.disconnectedProviders;
        synchronized (set) {
            this.disconnectedProviders.remove(p);
        }
    }

    protected void dispose() {
        this.tool.removeComponentProvider((ComponentProvider)this.connectedProvider);
        super.dispose();
    }

    public void processEvent(PluginEvent event) {
        PluginEvent ev;
        super.processEvent(event);
        if (event instanceof TraceActivatedPluginEvent) {
            ev = (TraceActivatedPluginEvent)event;
            this.connectedProvider.coordinatesActivated(ev.getActiveCoordinates());
        }
        if (event instanceof TraceClosedPluginEvent) {
            ev = (TraceClosedPluginEvent)event;
            this.traceClosed(ev.getTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceClosed(Trace trace) {
        this.connectedProvider.traceClosed(trace);
        Set<DebuggerRegistersProvider> set = this.disconnectedProviders;
        synchronized (set) {
            for (DebuggerRegistersProvider p : this.disconnectedProviders) {
                p.traceClosed(trace);
            }
        }
    }

    public static String encodeSetsByCSpec(Map<LanguageCompilerSpecPair, LinkedHashSet<Register>> setsByCSpec) {
        return setsByCSpec.entrySet().stream().map(ent -> {
            LanguageCompilerSpecPair lcsp = (LanguageCompilerSpecPair)ent.getKey();
            return String.valueOf(lcsp.languageID) + "/" + String.valueOf(lcsp.compilerSpecID) + ":" + ((LinkedHashSet)ent.getValue()).stream().filter(r -> r != null).map(Register::getName).collect(Collectors.joining(","));
        }).collect(Collectors.joining(";"));
    }

    public void writeConfigState(SaveState saveState) {
        String selectionByCSpecString = DebuggerRegistersPlugin.encodeSetsByCSpec(this.selectionByCSpec);
        saveState.putString(KEY_SELECTION_BY_CSPEC, selectionByCSpecString);
        String favoritesByCSpecString = DebuggerRegistersPlugin.encodeSetsByCSpec(this.favoritesByCSpec);
        saveState.putString(KEY_FAVORITES_BY_CSPEC, favoritesByCSpecString);
    }

    public static void readSetsByCSpec(Map<LanguageCompilerSpecPair, LinkedHashSet<Register>> setsByCSpec, String encoded) {
        String[] cSpecRegPairParts;
        LanguageService langServ = DefaultLanguageService.getLanguageService();
        if (encoded.length() == 0) {
            return;
        }
        for (String pairPart : cSpecRegPairParts = encoded.split(";")) {
            Language lang;
            Object[] parts = pairPart.split(":");
            if (parts.length < 2) {
                Msg.warn(DebuggerRegistersPlugin.class, (Object)("Bad cspec-regs entry: " + pairPart.substring(0, Math.min(10, pairPart.length())) + ". Ignoring."));
                continue;
            }
            String langCsPart = StringUtils.join((Object[])parts, (char)':', (int)0, (int)(parts.length - 1));
            Object regsPart = parts[parts.length - 1];
            String[] langCsParts = langCsPart.split("/");
            if (langCsParts.length != 2) {
                Msg.warn(DebuggerRegistersPlugin.class, (Object)("Bad lang-spec key: " + langCsPart + ". Ignoring."));
                continue;
            }
            LanguageID lid = new LanguageID(langCsParts[0]);
            try {
                lang = langServ.getLanguage(lid);
            }
            catch (LanguageNotFoundException e) {
                Msg.warn(DebuggerRegistersPlugin.class, (Object)("Language " + langCsParts[0] + " does not exist. Ignoring."));
                continue;
            }
            CompilerSpecID csid = new CompilerSpecID(langCsParts[1]);
            LinkedHashSet<Register> regs = new LinkedHashSet<Register>();
            for (String regName : ((String)regsPart).split(",")) {
                Register register = lang.getRegister(regName);
                if (register == null) {
                    Msg.warn(DebuggerRegistersPlugin.class, (Object)("Register " + regName + " does not exist. Ignoring."));
                    continue;
                }
                regs.add(register);
            }
            setsByCSpec.put(new LanguageCompilerSpecPair(lid, csid), regs);
        }
    }

    public void readConfigState(SaveState saveState) {
        String selectionByCSpecString = saveState.getString(KEY_SELECTION_BY_CSPEC, "");
        DebuggerRegistersPlugin.readSetsByCSpec(this.selectionByCSpec, selectionByCSpecString);
        String favoritesByCSpecString = saveState.getString(KEY_FAVORITES_BY_CSPEC, "");
        DebuggerRegistersPlugin.readSetsByCSpec(this.favoritesByCSpec, favoritesByCSpecString);
    }

    public void writeDataState(SaveState saveState) {
        List<DebuggerRegistersProvider> disconnected = List.copyOf(this.disconnectedProviders);
        saveState.putInt(KEY_DISCONNECTED_COUNT, disconnected.size());
        for (int index = 0; index < disconnected.size(); ++index) {
            DebuggerRegistersProvider provider = disconnected.get(index);
            String stateName = PREFIX_DISCONNECTED_PROVIDER + index;
            SaveState providerState = new SaveState();
            provider.writeDataState(providerState);
            saveState.putXmlElement(stateName, providerState.saveToXml());
        }
    }

    public void readDataState(SaveState saveState) {
        int disconnectedCount = saveState.getInt(KEY_DISCONNECTED_COUNT, 0);
        while (this.disconnectedProviders.size() < disconnectedCount) {
            this.createNewDisconnectedProvider();
        }
        while (this.disconnectedProviders.size() > disconnectedCount) {
            this.disconnectedProviders.iterator().next().removeFromTool();
        }
        List<DebuggerRegistersProvider> disconnected = List.copyOf(this.disconnectedProviders);
        for (int index = 0; index < disconnectedCount; ++index) {
            String stateName = PREFIX_DISCONNECTED_PROVIDER + index;
            Element providerElement = saveState.getXmlElement(stateName);
            if (providerElement == null) continue;
            SaveState providerState = new SaveState(providerElement);
            DebuggerRegistersProvider provider = disconnected.get(index);
            provider.readDataState(providerState);
        }
    }
}

