/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.client.tracermi;

import ghidra.app.plugin.core.debug.client.tracermi.MemoryMapper;
import ghidra.app.plugin.core.debug.client.tracermi.RegisterMapper;
import ghidra.app.plugin.core.debug.client.tracermi.RmiClient;
import ghidra.app.plugin.core.debug.client.tracermi.RmiTraceObject;
import ghidra.app.plugin.core.debug.client.tracermi.RmiTraceObjectValue;
import ghidra.app.plugin.core.debug.client.tracermi.RmiTransaction;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.lang.RegisterValue;
import ghidra.rmi.trace.TraceRmi;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.target.schema.SchemaContext;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RmiTrace {
    final RmiClient client;
    private final int id;
    private RmiClient.RequestResult createResult;
    private int nextTx = 0;
    private Object txLock = new Object();
    private ReadWriteLock snLock = new ReentrantReadWriteLock();
    private Set<String> overlays = new HashSet<String>();
    private long currentSnap = -1L;
    private boolean closed = false;
    public MemoryMapper memoryMapper;
    public RegisterMapper registerMapper;

    public RmiTrace(RmiClient client, int id, RmiClient.RequestResult createResult) {
        this.client = client;
        this.id = id;
        this.createResult = createResult;
    }

    public void checkResult(long timeoutMs) throws InterruptedException, ExecutionException, TimeoutException {
        this.createResult.get(timeoutMs, TimeUnit.MILLISECONDS);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.client.closeTrace(this.id);
    }

    public void save() {
        this.client.saveTrace(this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RmiTransaction startTx(String description, boolean undoable) {
        int txid;
        Object object = this.txLock;
        synchronized (object) {
            txid = this.nextTx++;
        }
        this.client.startTx(this.id, description, undoable, txid);
        return new RmiTransaction(this, txid);
    }

    public RmiTransaction openTx(String description) {
        return this.startTx(description, false);
    }

    public void endTx(int txid, boolean abort) {
        this.client.endTx(this.id, txid, abort);
    }

    public long nextSnap() {
        try (LockHold hold = LockHold.lock((Lock)this.snLock.writeLock());){
            long l = ++this.currentSnap;
            return l;
        }
    }

    public long snapshot(String description, String datatime, Long snap) {
        if (datatime == null) {
            datatime = "";
        }
        if (snap == null) {
            snap = this.nextSnap();
        }
        this.client.snapshot(this.id, description, datatime, snap.intValue());
        return snap;
    }

    public long getSnap() {
        try (LockHold hold = LockHold.lock((Lock)this.snLock.readLock());){
            long l = this.currentSnap;
            return l;
        }
    }

    public void setSnap(long snap) {
        try (LockHold hold = LockHold.lock((Lock)this.snLock.writeLock());){
            this.currentSnap = snap;
        }
    }

    public long snapOrCurrent(Long snap) {
        try (LockHold hold = LockHold.lock((Lock)this.snLock.readLock());){
            long l = snap == null ? this.currentSnap : snap;
            return l;
        }
    }

    public void createOverlaySpace(String base, String name) {
        if (this.overlays.contains(name)) {
            return;
        }
        this.client.createOverlaySpace(this.id, base, name);
    }

    public void createOverlaySpace(Address repl, Address orig) {
        this.createOverlaySpace(repl.getAddressSpace().getName(), orig.getAddressSpace().getName());
    }

    public void putBytes(Address addr, byte[] data, Long snap) {
        this.client.putBytes(this.id, this.snapOrCurrent(snap), addr, data);
    }

    public void setMemoryState(AddressRange range, TraceRmi.MemoryState state, Long snap) {
        this.client.setMemoryState(this.id, this.snapOrCurrent(snap), range, state);
    }

    public void deleteBytes(AddressRange range, Long snap) {
        this.client.deleteBytes(this.id, this.snapOrCurrent(snap), range);
    }

    public void putRegisters(String ppath, RegisterValue[] values, Long snap) {
        this.client.putRegisters(this.id, this.snapOrCurrent(snap), ppath, values);
    }

    public void deleteRegisters(String ppath, String[] names, Long snap) {
        this.client.deleteRegisters(this.id, this.snapOrCurrent(snap), ppath, names);
    }

    public void createRootObject(SchemaContext schemaContext, String schema) {
        this.client.createRootObject(this.id, schemaContext, schema);
    }

    public RmiTraceObject createObject(String path) {
        RmiClient.RequestResult result = this.client.createObject(this.id, path);
        return new RmiTraceObject(this, path, result);
    }

    public RmiTraceObject createAndInsertObject(String path) {
        RmiTraceObject object = this.createObject(path);
        object.insert(this.currentSnap, null);
        return object;
    }

    long handleCreateObject(TraceRmi.ReplyCreateObject reply) {
        return reply.getObject().getId();
    }

    public Void handleCreateTrace(TraceRmi.ReplyCreateTrace reply) {
        return null;
    }

    public List<RmiTraceObjectValue> handleGetValues(TraceRmi.ReplyGetValues reply) {
        ArrayList<RmiTraceObjectValue> result = new ArrayList<RmiTraceObjectValue>();
        for (TraceRmi.ValDesc d : reply.getValuesList()) {
            RmiTraceObject parent = this.proxyObject(d.getParent());
            Lifespan span = Lifespan.span((long)d.getSpan().getMin(), (long)d.getSpan().getMax());
            Object value = this.client.argToObject(this.id, d.getValue());
            TraceObjectSchema schema = this.client.getSchema(this.client.argToType(d.getValue()));
            result.add(new RmiTraceObjectValue(parent, span, d.getKey(), value, schema));
        }
        return result;
    }

    public long handleDisassemble(TraceRmi.ReplyDisassemble reply) {
        Msg.info((Object)this, (Object)("Disassembled " + reply.getLength() + " bytes"));
        return reply.getLength();
    }

    public void insertObject(String path) {
        Lifespan span = this.getLifespan();
        this.client.insertObject(this.id, path, span, TraceRmi.Resolution.CR_ADJUST);
    }

    private Lifespan getLifespan() {
        try (LockHold hold = LockHold.lock((Lock)this.snLock.readLock());){
            Lifespan lifespan = Lifespan.nowOn((long)this.currentSnap);
            return lifespan;
        }
    }

    public void setValue(String ppath, String key, Object value) {
        Lifespan span = this.getLifespan();
        this.client.setValue(this.id, ppath, span, key, value, null);
    }

    public void retainValues(String ppath, Set<String> keys, TraceRmi.ValueKinds kinds) {
        Lifespan span = this.getLifespan();
        this.client.retainValues(this.id, ppath, span, kinds, keys);
    }

    private <T> T doSync(RmiClient.RequestResult r) {
        if (this.client.hasBatch()) {
            return null;
        }
        try {
            return (T)r.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public RmiClient.RequestResult getValuesAsync(String pattern) {
        Lifespan span = this.getLifespan();
        return this.client.getValues(this.id, span, pattern);
    }

    public List<RmiTraceObjectValue> getValues(String pattern) {
        return (List)this.doSync(this.getValuesAsync(pattern));
    }

    public RmiClient.RequestResult getValuesRngAsync(Address start, long length) {
        Lifespan span = this.getLifespan();
        try {
            AddressRangeImpl range = new AddressRangeImpl(start, length);
            return this.client.getValuesIntersecting(this.id, span, (AddressRange)range, "");
        }
        catch (AddressOverflowException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public List<RmiTraceObjectValue> getValuesRng(Address start, long length) {
        return (List)this.doSync(this.getValuesRngAsync(start, length));
    }

    public void activate(String path) {
        if (path == null) {
            Msg.error((Object)this, (Object)"Attempt to activate null");
            return;
        }
        this.client.activate(this.id, path);
    }

    public void disassemble(Address start, Long snap) {
        this.client.disassemble(this.id, this.snapOrCurrent(snap), start);
    }

    public TraceRmi.XReplyInvokeMethod handleInvokeMethod(TraceRmi.XRequestInvokeMethod req) {
        try (RmiTransaction tx = this.startTx("InvokeMethod", false);){
            TraceRmi.XReplyInvokeMethod xReplyInvokeMethod = this.client.handleInvokeMethod(this.id, req);
            return xReplyInvokeMethod;
        }
    }

    private RmiTraceObject proxyObject(TraceRmi.ObjDesc desc) {
        return this.client.proxyObjectPath(this.id, desc.getId(), desc.getPath().getPath());
    }

    public RmiTraceObject proxyObjectId(Long objectId) {
        return this.client.proxyObjectId(this.id, objectId);
    }

    public RmiTraceObject proxyObjectPath(String path) {
        return this.client.proxyObjectPath(this.id, path);
    }

    public RmiTraceObject proxyObjectPath(Long objectId, String path) {
        return this.client.proxyObjectPath(this.id, objectId, path);
    }

    public int getId() {
        return this.id;
    }
}

