/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.graphanalysis;

import ghidra.app.decompiler.ClangToken;
import ghidra.program.model.pcode.HighFunction;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TokenBin
implements Iterable<ClangToken> {
    private ArrayList<ClangToken> bin = new ArrayList();
    private HighFunction highFunction;
    TokenBin sidekick;

    TokenBin(HighFunction highFunction) {
        this.highFunction = highFunction;
        this.sidekick = null;
    }

    public HighFunction getHighFunction() {
        return this.highFunction;
    }

    public TokenBin getMatch() {
        return this.sidekick;
    }

    public ClangToken get(int i) {
        return this.bin.get(i);
    }

    public int size() {
        return this.bin.size();
    }

    @Override
    public Iterator<ClangToken> iterator() {
        return this.bin.iterator();
    }

    void add(ClangToken newToken) {
        HighFunction tokenHighFunction = newToken.getClangFunction().getHighFunction();
        if (!this.highFunction.equals(tokenHighFunction)) {
            Msg.warn((Object)this, (Object)("ERROR: Trying to ADD token '" + newToken.getText() + "' to incorrect TokenBin."));
            return;
        }
        this.bin.add(newToken);
    }

    public static TokenBin getBinContainingToken(List<TokenBin> highBins, ClangToken myToken) {
        for (TokenBin bin : highBins) {
            for (ClangToken token : bin.bin) {
                if (myToken != token) continue;
                return bin;
            }
        }
        return null;
    }
}

