/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.app.util.PseudoData;
import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.WrappedMemBuffer;

class PseudoDataComponent
extends PseudoData {
    PseudoData parent;
    DataTypeComponent component;
    private int indexInParent;
    private int offset;
    private int[] path;

    PseudoDataComponent(Program program, Address address, PseudoData parent, DataTypeComponent component, MemBuffer memBuffer) throws AddressOverflowException {
        super(program, address, component.getDataType(), (MemBuffer)new WrappedMemBuffer(memBuffer, component.getOffset()));
        this.indexInParent = component.getOrdinal();
        this.parent = parent;
        this.component = component;
        this.level = parent.level + 1;
        this.offset = component.getOffset();
        this.length = component.getLength();
    }

    PseudoDataComponent(Program program, Address address, PseudoData parent, DataType dt, int ordinal, int offset, int length, MemBuffer memBuffer) throws AddressOverflowException {
        super(program, address, dt, (MemBuffer)new WrappedMemBuffer(memBuffer, offset));
        this.indexInParent = ordinal;
        this.parent = parent;
        this.offset = offset;
        this.level = parent.level + 1;
        this.length = length;
    }

    @Override
    public int[] getComponentPath() {
        if (this.path == null) {
            this.path = new int[this.level];
            int parentLevel = this.level - 1;
            this.path[parentLevel--] = this.indexInParent;
            PseudoData parentData = this.parent;
            while (parentData instanceof PseudoDataComponent) {
                PseudoDataComponent dc = (PseudoDataComponent)parentData;
                this.path[parentLevel--] = dc.indexInParent;
                parentData = dc.parent;
            }
        }
        return this.path;
    }

    @Override
    public String getFieldName() {
        if (this.component == null) {
            return "[" + this.indexInParent + "]";
        }
        Object myName = this.component.getFieldName();
        if (myName == null || ((String)myName).length() == 0) {
            myName = "field" + this.component.getOffset();
        }
        return myName;
    }

    @Override
    public String getPathName() {
        String parentPath = this.parent.getPathName();
        return this.getComponentName(parentPath);
    }

    @Override
    public String getComponentPathName() {
        String parentPath = this.parent.getComponentPathName();
        return this.getComponentName(parentPath);
    }

    private String getComponentName(String parentPath) {
        String myName;
        StringBuffer nameBuffer = new StringBuffer();
        if (parentPath != null && parentPath.length() > 0) {
            nameBuffer.append(parentPath);
            if (this.component != null) {
                nameBuffer.append('.');
            }
        }
        if ((myName = this.getFieldName()) == null || myName.length() <= 0) {
            nameBuffer.append("field");
            nameBuffer.append(this.component.getOffset());
        } else {
            nameBuffer.append(myName);
        }
        return nameBuffer.toString();
    }

    @Override
    public Data getParent() {
        return this.parent;
    }

    @Override
    public Data getRoot() {
        return this.parent.getRoot();
    }

    @Override
    public int getRootOffset() {
        return this.parent.getRootOffset() + this.getParentOffset();
    }

    @Override
    public int getParentOffset() {
        return this.offset;
    }

    @Override
    public int getComponentIndex() {
        return this.indexInParent;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != PseudoDataComponent.class) {
            return false;
        }
        PseudoDataComponent data = (PseudoDataComponent)obj;
        if (this.indexInParent != data.indexInParent || this.offset != data.offset) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public synchronized String getComment(CommentType commentType) {
        String cmt = super.getComment(commentType);
        if (cmt == null && commentType == CommentType.EOL && this.component != null) {
            cmt = this.component.getComment();
        }
        return cmt;
    }

    @Override
    public Settings getDefaultSettings() {
        if (this.component != null) {
            return this.component.getDefaultSettings();
        }
        return super.getDefaultSettings();
    }
}

