/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.pcoderaw;

import ghidra.pcodeCPort.address.Address;
import ghidra.pcodeCPort.address.AddressUtils;
import ghidra.pcodeCPort.space.AddrSpace;

public class VarnodeData {
    public AddrSpace space;
    public long offset;
    public int size;

    public VarnodeData() {
    }

    public VarnodeData(AddrSpace base, long off, int size) {
        this.space = base;
        this.offset = off;
        this.size = size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != VarnodeData.class) {
            return false;
        }
        VarnodeData other = (VarnodeData)obj;
        return this.space == other.space && this.offset == other.offset && this.size == other.size;
    }

    public int hashCode() {
        return this.space.hashCode() + (int)this.offset + this.size;
    }

    public int compareTo(VarnodeData other) {
        int result = this.space.compareTo(other.space);
        if (result != 0) {
            return result;
        }
        result = AddressUtils.unsignedCompare(this.offset, other.offset);
        if (result != 0) {
            return result;
        }
        return other.size - this.size;
    }

    public Address getAddress() {
        return new Address(this.space, this.offset);
    }
}

