/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.references;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import db.Table;
import db.util.ErrorHandler;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressKeyAddressIterator;
import ghidra.program.database.map.AddressKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.references.RecordAdapter;
import ghidra.program.database.references.RefList;
import ghidra.program.database.references.RefListV0;
import ghidra.program.database.references.ToAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.symbol.Reference;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class ToAdapterV0
extends ToAdapter {
    private Table table;
    private AddressMap addrMap;
    private ErrorHandler errHandler;

    ToAdapterV0(DBHandle handle, AddressMap addrMap, ErrorHandler errHandler) throws VersionException {
        this.addrMap = addrMap.getOldAddressMap();
        this.errHandler = errHandler;
        this.table = handle.getTable("TO REFS");
        if (this.table == null) {
            throw new VersionException("Missing Table: TO REFS");
        }
        if (this.table.getSchema().getVersion() != 0) {
            throw new VersionException(false);
        }
    }

    @Override
    public RefList createRefList(ProgramDB program, DBObjectCache<RefList> cache, Address to) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RefList getRefList(ProgramDB program, DBObjectCache<RefList> cache, Address to, long toAddr) throws IOException {
        DBRecord rec = this.translateRecord(this.table.getRecord(toAddr));
        if (rec != null) {
            return new RefListV0(rec, (RecordAdapter)this, this.addrMap, program, cache, false);
        }
        return null;
    }

    @Override
    boolean hasRefTo(long toAddr) throws IOException {
        return this.table.hasRecord(toAddr);
    }

    @Override
    public DBRecord createRecord(long key, int numRefs, byte refLevel, byte[] refData) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DBRecord getRecord(long key) throws IOException {
        return this.translateRecord(this.table.getRecord(key));
    }

    @Override
    public void putRecord(DBRecord record) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeRecord(long key) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    AddressIterator getToIterator(boolean forward) throws IOException {
        return new AddressKeyAddressIterator(new AddressKeyIterator(this.table, this.addrMap, forward), forward, this.addrMap, this.errHandler);
    }

    @Override
    AddressIterator getToIterator(Address startAddr, boolean forward) throws IOException {
        return new AddressKeyAddressIterator(new AddressKeyIterator(this.table, this.addrMap, startAddr, forward), forward, this.addrMap, this.errHandler);
    }

    @Override
    AddressIterator getToIterator(AddressSetView set, boolean forward) throws IOException {
        return new AddressKeyAddressIterator(new AddressKeyIterator(this.table, this.addrMap, set, set.getMinAddress(), forward), forward, this.addrMap, this.errHandler);
    }

    @Override
    AddressIterator getOldNamespaceAddresses(AddressSpace addrSpace) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    int getRecordCount() {
        return this.table.getRecordCount();
    }

    private DBRecord translateRecord(DBRecord oldRec) {
        if (oldRec == null) {
            return null;
        }
        DBRecord rec = TO_REFS_SCHEMA.createRecord(oldRec.getKey());
        rec.setIntValue(0, oldRec.getIntValue(0));
        rec.setBinaryData(1, oldRec.getBinaryData(1));
        rec.setByteValue(2, this.getRefLevel(rec));
        return rec;
    }

    private byte getRefLevel(DBRecord newRec) {
        try {
            RefListV0 refList = new RefListV0(newRec, (RecordAdapter)this, this.addrMap, null, null, false);
            Reference[] refs = ((RefList)refList).getAllRefs();
            byte refLevel = -1;
            for (Reference ref : refs) {
                byte level = RefListV0.getRefLevel(ref.getReferenceType());
                if (level <= refLevel) continue;
                refLevel = level;
            }
            return refLevel;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException unexpected for ToAdapterV0 RefList");
        }
    }

    class TranslatedRecordIterator
    implements RecordIterator {
        private RecordIterator it;

        TranslatedRecordIterator(RecordIterator it) {
            this.it = it;
        }

        public boolean delete() throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() throws IOException {
            return this.it.hasNext();
        }

        public boolean hasPrevious() throws IOException {
            return this.it.hasPrevious();
        }

        public DBRecord next() throws IOException {
            DBRecord rec = this.it.next();
            return ToAdapterV0.this.translateRecord(rec);
        }

        public DBRecord previous() throws IOException {
            DBRecord rec = this.it.previous();
            return ToAdapterV0.this.translateRecord(rec);
        }
    }
}

