/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.BitFieldPacking;
import ghidra.program.model.data.DataType;
import java.util.Arrays;

public interface DataOrganization {
    public static final int NO_MAXIMUM_ALIGNMENT = 0;

    public boolean isBigEndian();

    public int getPointerSize();

    public int getPointerShift();

    public boolean isSignedChar();

    public int getCharSize();

    public int getWideCharSize();

    public int getShortSize();

    public int getIntegerSize();

    public int getLongSize();

    public int getLongLongSize();

    public int getFloatSize();

    public int getDoubleSize();

    public int getLongDoubleSize();

    public int getAbsoluteMaxAlignment();

    public int getMachineAlignment();

    public int getDefaultAlignment();

    public int getDefaultPointerAlignment();

    public int getSizeAlignment(int var1);

    public BitFieldPacking getBitFieldPacking();

    public int getSizeAlignmentCount();

    public int[] getSizes();

    public String getIntegerCTypeApproximation(int var1, boolean var2);

    public int getAlignment(DataType var1);

    default public boolean isEquivalent(DataOrganization obj) {
        int[] op2keys;
        if (this.getAbsoluteMaxAlignment() != obj.getAbsoluteMaxAlignment()) {
            return false;
        }
        if (this.isBigEndian() != obj.isBigEndian()) {
            return false;
        }
        if (!this.getBitFieldPacking().isEquivalent(obj.getBitFieldPacking())) {
            return false;
        }
        if (this.getCharSize() != obj.getCharSize() || this.getWideCharSize() != obj.getWideCharSize()) {
            return false;
        }
        if (this.getDefaultAlignment() != obj.getDefaultAlignment()) {
            return false;
        }
        if (this.getDefaultPointerAlignment() != obj.getDefaultPointerAlignment()) {
            return false;
        }
        if (this.getDoubleSize() != obj.getDoubleSize() || this.getFloatSize() != obj.getFloatSize()) {
            return false;
        }
        if (this.getIntegerSize() != obj.getIntegerSize() || this.getLongLongSize() != obj.getLongLongSize()) {
            return false;
        }
        if (this.getShortSize() != obj.getShortSize()) {
            return false;
        }
        if (this.getLongSize() != obj.getLongSize() || this.getLongDoubleSize() != obj.getLongDoubleSize()) {
            return false;
        }
        if (this.isSignedChar() != obj.isSignedChar()) {
            return false;
        }
        if (this.getMachineAlignment() != obj.getMachineAlignment()) {
            return false;
        }
        if (this.getPointerSize() != obj.getPointerSize() || this.getPointerShift() != obj.getPointerShift()) {
            return false;
        }
        int[] keys = this.getSizes();
        if (!Arrays.equals(keys, op2keys = obj.getSizes())) {
            return false;
        }
        for (int k : keys) {
            if (this.getSizeAlignment(k) == obj.getSizeAlignment(k)) continue;
            return false;
        }
        return true;
    }
}

