/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeNameComparator;
import java.util.Comparator;

public class DataTypeComparator
implements Comparator<DataType> {
    public static DataTypeComparator INSTANCE = new DataTypeComparator();

    @Override
    public int compare(DataType dt1, DataType dt2) {
        String name2;
        String name1 = dt1.getName();
        int nameCompare = DataTypeNameComparator.INSTANCE.compare(name1, name2 = dt2.getName());
        if (nameCompare == 0) {
            String dtmName2;
            DataTypeManager dtm1 = dt1.getDataTypeManager();
            String dtmName1 = dtm1 != null ? dtm1.getName() : null;
            DataTypeManager dtm2 = dt2.getDataTypeManager();
            String string = dtmName2 = dtm2 != null ? dtm2.getName() : null;
            if (dtm1 == null && dtm2 != null) {
                return -1;
            }
            if (dtm2 == null) {
                return 1;
            }
            int compare = dtmName1.compareTo(dtmName2);
            if (compare == 0) {
                String catPath1 = dt1.getCategoryPath().getPath();
                String catPath2 = dt2.getCategoryPath().getPath();
                compare = catPath1.compareTo(catPath2);
            }
            return compare;
        }
        return nameCompare;
    }
}

