/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.ReadOnlyDataTypeComponent;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBufferImpl;
import ghidra.util.Msg;
import java.util.Hashtable;

public abstract class IndexedDynamicDataType
extends DynamicDataType {
    public static final String NULL_BODY_DESCRIPTION = "NullBody";
    protected String description;
    protected DataType header;
    protected long[] keys;
    protected DataType[] structs;
    protected long indexOffset;
    protected int indexSize;
    protected long mask;
    private Hashtable<Long, Integer> table = new Hashtable();

    public IndexedDynamicDataType(String name, String description, DataType header, long[] keys, DataType[] structs, long indexOffset, int indexSize, long mask, DataTypeManager dtm) {
        super(name, dtm);
        this.description = description;
        this.header = header;
        this.keys = keys;
        this.structs = structs;
        this.indexOffset = indexOffset;
        this.indexSize = indexSize;
        this.mask = mask;
        if (keys.length != structs.length) {
            Msg.error((Object)this, (Object)"ERROR: keys.length must equal structs.length");
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            this.table.put(keys[i], i);
        }
        if (mask == 0L) {
            mask = -1L;
        }
    }

    public IndexedDynamicDataType(String name, String description, DataType header, long singleKey, DataType[] structs, long indexOffset, int indexSize, long mask, DataTypeManager dtm) {
        super(name, dtm);
        this.name = name;
        this.description = description;
        this.header = header;
        this.keys = new long[]{singleKey};
        this.structs = structs;
        this.indexOffset = indexOffset;
        this.indexSize = indexSize;
        long l = this.mask = mask == 0L ? -1L : mask;
        if (structs.length > 2) {
            Msg.warn((Object)this, (Object)"WARNING: IndexedDynamicDataType constructed using single key -- only first two structures will be used");
        }
        for (int i = 0; i < structs.length; ++i) {
            this.table.put(Long.valueOf(i), i);
        }
    }

    @Override
    protected DataTypeComponent[] getAllComponents(MemBuffer buf) {
        Memory memory = buf.getMemory();
        Address start = buf.getAddress();
        long index = this.getIndex(memory, start.add(this.indexOffset)) & this.mask;
        Integer structIndex = null;
        structIndex = this.keys.length == 1 ? (index == this.keys[0] ? Integer.valueOf(0) : Integer.valueOf(1)) : this.table.get(index);
        if (structIndex == null) {
            Msg.error((Object)this, (Object)("ERROR in " + this.name + " at " + String.valueOf(start)));
            return null;
        }
        DataType data = this.structs[structIndex];
        if (data == null) {
            Msg.error((Object)this, (Object)("ERROR in " + this.name + " at " + String.valueOf(start)));
            return null;
        }
        DataTypeComponent[] comps = null;
        comps = data.getDescription().equalsIgnoreCase(NULL_BODY_DESCRIPTION) ? new DataTypeComponent[1] : new DataTypeComponent[2];
        MemoryBufferImpl newBuf = new MemoryBufferImpl(memory, buf.getAddress());
        DataTypeInstance dti = DataTypeInstance.getDataTypeInstance(this.header, newBuf, false);
        if (dti == null) {
            Msg.error((Object)this, (Object)("ERROR: problem with data at " + String.valueOf(newBuf.getAddress())));
            return null;
        }
        int len = dti.getLength();
        comps[0] = new ReadOnlyDataTypeComponent(this.header, this, len, 0, 0, dti.getDataType().getName(), "");
        if (comps.length > 1) {
            try {
                int countSize;
                int offset = countSize = len;
                newBuf = new MemoryBufferImpl(memory, buf.getAddress());
                newBuf.advance(countSize);
                dti = DataTypeInstance.getDataTypeInstance(data, newBuf, false);
                if (dti == null) {
                    Msg.error((Object)this, (Object)("ERROR: problem with data at " + String.valueOf(newBuf.getAddress())));
                    return null;
                }
                len = dti.getLength();
                comps[1] = new ReadOnlyDataTypeComponent(dti.getDataType(), this, len, 1, offset, dti.getDataType().getName() + "_" + String.valueOf(newBuf.getAddress()), "");
            }
            catch (AddressOverflowException e) {
                Msg.error((Object)this, (Object)("ERROR: problem with data at " + String.valueOf(newBuf.getAddress())));
                return null;
            }
        }
        return comps;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "";
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.name;
    }

    private long getIndex(Memory memory, Address loc) {
        long test = 0L;
        try {
            switch (this.indexSize) {
                case 1: {
                    test = Byte.toUnsignedLong(memory.getByte(loc));
                    break;
                }
                case 2: {
                    test = Short.toUnsignedLong(memory.getShort(loc));
                    break;
                }
                case 4: {
                    test = Integer.toUnsignedLong(memory.getInt(loc));
                    break;
                }
                case 8: {
                    test = memory.getLong(loc);
                    break;
                }
                default: {
                    return 0L;
                }
            }
        }
        catch (MemoryAccessException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)((Object)e));
        }
        return test;
    }
}

