/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.scalar;

import java.math.BigInteger;

public class Scalar {
    private final long value;
    private final byte bitLength;
    private final byte unusedBits;
    private final boolean signed;

    public Scalar(int bitLength, long value) {
        this(bitLength, value, true);
    }

    public Scalar(int bitLength, long value, boolean signed) {
        if (!(bitLength == 0 && value == 0L || bitLength >= 1 && bitLength <= 64)) {
            throw new IllegalArgumentException("Bit length must be >= 1 and <= 64");
        }
        this.signed = signed;
        this.bitLength = (byte)bitLength;
        this.unusedBits = (byte)(64 - bitLength);
        this.value = value << this.unusedBits >>> this.unusedBits;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public long getSignedValue() {
        return this.value << this.unusedBits >> this.unusedBits;
    }

    public long getUnsignedValue() {
        return this.value;
    }

    public long getValue() {
        return this.signed ? this.getSignedValue() : this.value;
    }

    public long getValue(boolean signednessOverride) {
        return signednessOverride ? this.getSignedValue() : this.value;
    }

    public BigInteger getBigInteger() {
        int signum = this.signed && this.testBit(this.bitLength - 1) ? -1 : 1;
        int numBytes = (this.bitLength - 1) / 8 + 1;
        long tmpVal = this.getValue();
        if (this.signed && tmpVal < 0L) {
            tmpVal = -tmpVal;
        }
        byte[] data = new byte[numBytes];
        for (int i = numBytes - 1; i >= 0; --i) {
            data[i] = (byte)tmpVal;
            tmpVal >>= 8;
        }
        return new BigInteger(signum, data);
    }

    public byte[] byteArrayValue() {
        int numBytes = (this.bitLength - 1) / 8 + 1;
        long tmpVal = this.getValue();
        byte[] data = new byte[numBytes];
        for (int i = numBytes - 1; i >= 0; --i) {
            data[i] = (byte)tmpVal;
            tmpVal >>= 8;
        }
        return data;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Scalar other = (Scalar)obj;
        long v = this.getValue();
        if (v != other.getValue()) {
            return false;
        }
        if (v < 0L && (this.bitLength == 64 || other.bitLength == 64)) {
            return this.signed == other.signed;
        }
        return true;
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public int bitLength() {
        return this.bitLength;
    }

    public boolean testBit(int n) {
        if (n < 0 || n > this.bitLength - 1) {
            throw new IllegalArgumentException();
        }
        return (this.value & 1L << n) != 0L;
    }

    public String toString(int radix, boolean zeroPadded, boolean showSign, String pre, String post) {
        String b;
        long val;
        if (!this.signed) {
            showSign = false;
        }
        if (showSign) {
            val = this.getSignedValue();
            int shiftCnt = 64 - this.bitLength;
            val <<= shiftCnt;
            val >>= shiftCnt;
        } else {
            val = this.getUnsignedValue();
        }
        StringBuffer buf = new StringBuffer(32);
        if (this.bitLength == 64 && !this.signed) {
            b = this.getBigInteger().toString(radix);
        } else if (radix == 10) {
            b = Long.toString(val);
        } else {
            if (showSign && val < 0L) {
                val = -val;
                buf.append('-');
            }
            switch (radix) {
                case 2: {
                    b = Long.toBinaryString(val);
                    break;
                }
                case 8: {
                    b = Long.toOctalString(val);
                    break;
                }
                case 16: {
                    b = Long.toHexString(val);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid radix");
                }
            }
        }
        buf.append(pre);
        if (zeroPadded) {
            int numDigits = this.getDigits(radix);
            for (int i = 0; i < numDigits - b.length(); ++i) {
                buf.append("0");
            }
        }
        buf.append(b);
        buf.append(post);
        return new String(buf);
    }

    public String toString() {
        return this.toString(16, false, true, "0x", "");
    }

    private int getDigits(int radix) {
        switch (radix) {
            case 2: {
                return this.bitLength;
            }
            case 8: {
                return (this.bitLength - 1) / 3 + 1;
            }
            case 16: {
                return (this.bitLength - 1) / 4 + 1;
            }
        }
        return 0;
    }
}

