/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class SimpleDiffUtility {
    public static VariableStorage getCompatibleVariableStorage(Program program, VariableStorage storage, Program otherProgram) {
        if (storage == null || storage.size() == 0 || storage.isHashStorage()) {
            return storage;
        }
        Varnode[] varnodes = storage.getVarnodes();
        for (int i = 0; i < varnodes.length; ++i) {
            varnodes[i] = SimpleDiffUtility.getCompatibleVarnode(program, varnodes[i], otherProgram);
            if (varnodes[i] != null) continue;
            return null;
        }
        try {
            return new VariableStorage((ProgramArchitecture)otherProgram, varnodes);
        }
        catch (InvalidInputException e) {
            throw new RuntimeException(e);
        }
    }

    public static Varnode getCompatibleVarnode(Program program, Varnode varnode, Program otherProgram) {
        Address otherAddr;
        if (varnode == null || varnode.isConstant()) {
            return varnode;
        }
        Address addr = varnode.getAddress();
        if (addr.isRegisterAddress()) {
            Register otherReg;
            if (program.getLanguageID().equals(otherProgram.getLanguageID())) {
                return varnode;
            }
            Register reg = program.getRegister(addr, varnode.getSize());
            if (reg != null && (otherReg = otherProgram.getRegister(reg.getName())) != null && reg.getMinimumByteSize() == otherReg.getMinimumByteSize()) {
                long delta = addr.subtract(reg.getAddress());
                if (delta != 0L) {
                    return new Varnode(otherReg.getAddress().add(delta), varnode.getSize());
                }
                return new Varnode(otherReg.getAddress(), varnode.getSize());
            }
            return null;
        }
        if ((addr.isMemoryAddress() || addr.isStackAddress()) && (otherAddr = SimpleDiffUtility.getCompatibleAddress(program, addr, otherProgram)) != null) {
            return new Varnode(otherAddr, varnode.getSize());
        }
        return null;
    }

    public static Address getStartOfDelaySlots(Instruction instr) {
        Listing listing = instr.getProgram().getListing();
        Instruction prevInstr = instr;
        Address minAddr = prevInstr.getMinAddress();
        try {
            while (prevInstr != null && prevInstr.isInDelaySlot()) {
                minAddr = prevInstr.getMinAddress();
                prevInstr = listing.getInstructionContaining(minAddr.subtractNoWrap(1L));
            }
            if (prevInstr != null) {
                minAddr = prevInstr.getMinAddress();
            }
        }
        catch (AddressOverflowException addressOverflowException) {
            // empty catch block
        }
        return minAddr;
    }

    public static Address getEndOfDelaySlots(Instruction instr) {
        Listing listing = instr.getProgram().getListing();
        Address maxAddr = instr.getMaxAddress();
        try {
            Instruction nextInstr = listing.getInstructionAt(maxAddr.addNoWrap(1L));
            while (nextInstr != null && nextInstr.isInDelaySlot()) {
                maxAddr = nextInstr.getMaxAddress();
                nextInstr = listing.getInstructionAt(maxAddr.addNoWrap(1L));
            }
        }
        catch (AddressOverflowException addressOverflowException) {
            // empty catch block
        }
        return maxAddr;
    }

    public static AddressSetView expandAddressSetToIncludeFullDelaySlots(Program program, AddressSetView originalSet) {
        Listing listing = program.getListing();
        AddressSetView expandedSet = null;
        for (AddressRange originRange : originalSet.getAddressRanges()) {
            Address newMaxAddr;
            Address newMinAddr;
            Instruction instr = listing.getInstructionAt(originRange.getMinAddress());
            if (instr != null && instr.isInDelaySlot() && !(newMinAddr = SimpleDiffUtility.getStartOfDelaySlots(instr)).equals(originRange.getMinAddress())) {
                if (expandedSet == null) {
                    expandedSet = new AddressSet(originalSet);
                }
                ((AddressSet)expandedSet).addRange(newMinAddr, instr.getMaxAddress());
            }
            if ((instr = listing.getInstructionContaining(originRange.getMaxAddress())) == null || !instr.isInDelaySlot() && instr.getDelaySlotDepth() == 0 || (newMaxAddr = SimpleDiffUtility.getEndOfDelaySlots(instr)).equals(originRange.getMaxAddress())) continue;
            if (expandedSet == null) {
                expandedSet = new AddressSet(originalSet);
            }
            ((AddressSet)expandedSet).addRange(instr.getMinAddress(), newMaxAddr);
        }
        return expandedSet != null ? expandedSet : originalSet;
    }

    public static Address getCompatibleAddress(Program program, Address addr, Program otherProgram) {
        if (addr == null) {
            return null;
        }
        if (addr.isMemoryAddress()) {
            return SimpleDiffUtility.translateMemoryAddress(addr, otherProgram, true);
        }
        if (addr.isVariableAddress()) {
            throw new IllegalArgumentException("correlation of variables by their variable address not allowed");
        }
        if (addr.isStackAddress()) {
            return otherProgram.getAddressFactory().getStackSpace().getAddress(addr.getOffset());
        }
        if (addr.isRegisterAddress()) {
            Register otherReg;
            if (program.getLanguage().getLanguageID().equals(otherProgram.getLanguage().getLanguageID())) {
                return addr;
            }
            Register reg = program.getRegister(addr);
            if (reg != null && (otherReg = otherProgram.getRegister(reg.getName())) != null && reg.getMinimumByteSize() == otherReg.getMinimumByteSize()) {
                long delta = addr.subtract(reg.getAddress());
                if (delta != 0L) {
                    return otherReg.getAddress().add(delta);
                }
                return otherReg.getAddress();
            }
            return null;
        }
        if (addr.isExternalAddress()) {
            Symbol s = program.getSymbolTable().getPrimarySymbol(addr);
            if (s != null && s.isExternal() && (s = SimpleDiffUtility.getMatchingExternalSymbol(program, s, otherProgram, true, null)) != null) {
                return s.getAddress();
            }
            return null;
        }
        if (addr.getAddressSpace().getType() == 15 || addr.getAddressSpace().getType() == 14) {
            return addr;
        }
        throw new IllegalArgumentException("Unsupported address type");
    }

    protected static Address translateMemoryAddress(Address addr, Program otherProgram, boolean exactMatchOnly) {
        if (!addr.isMemoryAddress()) {
            return null;
        }
        AddressSpace addrSpace = addr.getAddressSpace();
        AddressSpace otherSpace = SimpleDiffUtility.getCompatibleAddressSpace(addrSpace, otherProgram);
        if (otherSpace != null) {
            try {
                return otherSpace.getAddressInThisSpaceOnly(addr.getOffset());
            }
            catch (AddressOutOfBoundsException e) {
                return null;
            }
        }
        return null;
    }

    public static AddressSpace getCompatibleAddressSpace(AddressSpace addrSpace, Program otherProgram) {
        AddressSpace otherSpace = otherProgram.getAddressFactory().getAddressSpace(addrSpace.getName());
        if (otherSpace != null && otherSpace.getType() == addrSpace.getType() && otherSpace.isOverlaySpace() == addrSpace.isOverlaySpace()) {
            int otherid;
            int id = addrSpace.isOverlaySpace() ? ((OverlayAddressSpace)addrSpace).getBaseSpaceID() : addrSpace.getSpaceID();
            int n = otherid = otherSpace.isOverlaySpace() ? ((OverlayAddressSpace)otherSpace).getBaseSpaceID() : otherSpace.getSpaceID();
            if (id == otherid) {
                return otherSpace;
            }
        }
        return null;
    }

    public static Symbol getSymbol(Symbol symbol, Program otherProgram) {
        Namespace otherNamespace;
        if (symbol == null) {
            return null;
        }
        SymbolType symbolType = symbol.getSymbolType();
        if (symbolType == SymbolType.GLOBAL) {
            return otherProgram.getGlobalNamespace().getSymbol();
        }
        String name = symbol.getName();
        Symbol otherParent = SimpleDiffUtility.getSymbol(symbol.getParentSymbol(), otherProgram);
        Namespace namespace = otherNamespace = otherParent == null ? null : (Namespace)otherParent.getObject();
        if (otherNamespace == null) {
            return null;
        }
        if (symbolType == SymbolType.LIBRARY) {
            return otherProgram.getSymbolTable().getLibrarySymbol(name);
        }
        if (symbolType == SymbolType.CLASS) {
            return otherProgram.getSymbolTable().getClassSymbol(name, otherNamespace);
        }
        if (symbolType == SymbolType.NAMESPACE) {
            return otherProgram.getSymbolTable().getNamespaceSymbol(name, otherNamespace);
        }
        if (symbolType == SymbolType.PARAMETER || symbolType == SymbolType.LOCAL_VAR) {
            return SimpleDiffUtility.getVariableSymbol(symbol, otherProgram, otherNamespace);
        }
        if (symbolType == SymbolType.FUNCTION) {
            return SimpleDiffUtility.getOtherFunctionSymbol(symbol, otherProgram, otherNamespace);
        }
        if (symbolType == SymbolType.LABEL) {
            return SimpleDiffUtility.getOtherCodeSymbol(symbol, otherProgram, otherNamespace);
        }
        throw new AssertException("Got unexpected SymbolType: " + String.valueOf(symbolType));
    }

    private static Symbol getOtherCodeSymbol(Symbol symbol, Program otherProgram, Namespace namespace) {
        SymbolType otherType;
        if (symbol.isExternal()) {
            return SimpleDiffUtility.getOtherExternalLocationSymbol(symbol, otherProgram, namespace);
        }
        Address otherAddress = SimpleDiffUtility.getCompatibleAddress(symbol.getProgram(), symbol.getAddress(), otherProgram);
        if (otherAddress == null) {
            return null;
        }
        Symbol otherSymbol = otherProgram.getSymbolTable().getSymbol(symbol.getName(), otherAddress, namespace);
        SymbolType symbolType = otherType = otherSymbol == null ? null : otherSymbol.getSymbolType();
        if (otherType == symbol.getSymbolType()) {
            return otherSymbol;
        }
        return null;
    }

    private static Symbol getOtherFunctionSymbol(Symbol symbol, Program otherProgram, Namespace otherNamespace) {
        if (symbol.isExternal()) {
            return SimpleDiffUtility.getOtherExternalLocationSymbol(symbol, otherProgram, otherNamespace);
        }
        Function func = (Function)symbol.getObject();
        Address entryPoint = func.getEntryPoint();
        Address otherEntry = SimpleDiffUtility.getCompatibleAddress(symbol.getProgram(), entryPoint, otherProgram);
        if (otherEntry == null) {
            return null;
        }
        func = otherProgram.getFunctionManager().getFunctionAt(otherEntry);
        return func != null ? func.getSymbol() : null;
    }

    private static Symbol getOtherExternalLocationSymbol(Symbol symbol, Program otherProgram, Namespace otherNamespace) {
        ExternalLocation external = SimpleDiffUtility.getExternalLocation(symbol);
        SymbolTable otherSymbolTable = otherProgram.getSymbolTable();
        List<Symbol> otherSymbols = otherSymbolTable.getSymbols(symbol.getName(), otherNamespace);
        if (otherSymbols.size() == 1) {
            Symbol s = otherSymbols.get(0);
            return s.getSymbolType() == symbol.getSymbolType() ? s : null;
        }
        for (Symbol s : otherSymbols) {
            ExternalLocation otherExternalLocation = SimpleDiffUtility.getExternalLocation(s);
            if (!external.isEquivalent(otherExternalLocation)) continue;
            return s;
        }
        return null;
    }

    private static ExternalLocation getExternalLocation(Symbol symbol) {
        if (symbol == null) {
            return null;
        }
        Program p = symbol.getProgram();
        return p.getExternalManager().getExternalLocation(symbol);
    }

    private static ExternalMatchType testExternalMatch(ExternalLocation extLoc1, ExternalLocation extLoc2) {
        ExternalMatchType matchType = SimpleDiffUtility.testExternalNameMatch(extLoc1, extLoc2);
        if (matchType == ExternalMatchType.NONE) {
            return SimpleDiffUtility.hasExternalAddressMatch(extLoc1, extLoc2) ? ExternalMatchType.ADDRESS : ExternalMatchType.NONE;
        }
        return matchType;
    }

    private static boolean hasExternalAddressMatch(ExternalLocation extLoc1, ExternalLocation extLoc2) {
        Address addr1 = extLoc1.getAddress();
        return addr1 != null && addr1.equals(extLoc2.getAddress());
    }

    private static ExternalMatchType testExternalNameMatch(ExternalLocation extLoc1, ExternalLocation extLoc2) {
        boolean isDefaul2;
        boolean isDefaul1 = extLoc1.getSymbol().getSource() == SourceType.DEFAULT;
        boolean bl = isDefaul2 = extLoc2.getSymbol().getSource() == SourceType.DEFAULT;
        if (isDefaul1 || isDefaul2) {
            return ExternalMatchType.NONE;
        }
        if (!extLoc1.getLibraryName().equals(extLoc2.getLibraryName())) {
            return ExternalMatchType.NONE;
        }
        String name1 = extLoc1.getLabel();
        String name2 = extLoc2.getLabel();
        String origName1 = extLoc1.getOriginalImportedName();
        String origName2 = extLoc2.getOriginalImportedName();
        if (origName1 != null) {
            if (origName2 != null) {
                return origName1.equals(origName2) ? ExternalMatchType.MANGLED_NAME : ExternalMatchType.NONE;
            }
            if (extLoc2.getSymbol().getParentNamespace().isLibrary() && origName1.equals(name2)) {
                return ExternalMatchType.MANGLED_NAME;
            }
        } else if (origName2 != null && extLoc1.getSymbol().getParentNamespace().isLibrary() && origName2.equals(name1)) {
            return ExternalMatchType.MANGLED_NAME;
        }
        return name1.equals(name2) ? ExternalMatchType.NAME : ExternalMatchType.NONE;
    }

    public static Symbol getMatchingExternalSymbol(Program program, Symbol symbol, Program otherProgram, boolean allowInferredMatch, Set<Long> otherRestrictedSymbolIds) {
        Object[] matches;
        Symbol otherParent;
        if (symbol == null) {
            return null;
        }
        SymbolType type = symbol.getSymbolType();
        if (type != SymbolType.FUNCTION && type != SymbolType.LABEL || !symbol.isExternal()) {
            return null;
        }
        if (allowInferredMatch && program.getUniqueProgramID() != otherProgram.getUniqueProgramID()) {
            allowInferredMatch = false;
        }
        ExternalManager extMgr = program.getExternalManager();
        ExternalLocation extLoc = extMgr.getExternalLocation(symbol);
        String targetName = symbol.getSource() != SourceType.DEFAULT ? symbol.getName() : null;
        String targetOrigImportedName = extLoc.getOriginalImportedName();
        String targetNamespace = symbol.getParentNamespace().getName(true);
        if (targetNamespace.startsWith("<EXTERNAL>")) {
            targetNamespace = null;
        }
        Address targetAddr = extLoc.getAddress();
        SymbolTable otherSymbMgr = otherProgram.getSymbolTable();
        ExternalManager otherExtMgr = otherProgram.getExternalManager();
        HashMap<Address, ExternalReferenceCount> matchesMap = new HashMap<Address, ExternalReferenceCount>();
        if (symbol.getSource() != SourceType.DEFAULT && (otherParent = SimpleDiffUtility.getSymbol(symbol.getParentSymbol(), otherProgram)) != null) {
            SymbolIterator symbols = otherProgram.getSymbolTable().getExternalSymbols(symbol.getName());
            for (Symbol otherSym : symbols) {
                ExternalMatchType matchType;
                ExternalLocation otherExtLoc = otherExtMgr.getExternalLocation(otherSym);
                if (otherExtLoc == null || (matchType = SimpleDiffUtility.testExternalMatch(otherExtLoc, extLoc)) == ExternalMatchType.NONE) continue;
                ExternalReferenceCount refMatch = new ExternalReferenceCount(otherExtLoc, matchType);
                refMatch.setRelativeRank(targetAddr, targetNamespace, targetName, targetOrigImportedName);
                matchesMap.put(otherSym.getAddress(), refMatch);
            }
        }
        if (allowInferredMatch && matchesMap.isEmpty()) {
            Address[] thunkAddrs;
            ReferenceManager refMgr = program.getReferenceManager();
            ReferenceManager otherRefMgr = otherProgram.getReferenceManager();
            ReferenceIterator refIter = refMgr.getReferencesTo(symbol.getAddress());
            int totalMatchCnt = 0;
            while (refIter.hasNext()) {
                Reference ref = refIter.next();
                Reference otherRef = otherRefMgr.getPrimaryReferenceFrom(ref.getFromAddress(), ref.getOperandIndex());
                if (otherRef == null || !otherRef.isExternalReference()) continue;
                Address otherExtAddr = otherRef.getToAddress();
                ExternalReferenceCount refMatch = (ExternalReferenceCount)matchesMap.get(otherExtAddr);
                if (refMatch == null) {
                    Symbol otherSym = otherSymbMgr.getPrimarySymbol(otherExtAddr);
                    if (otherRestrictedSymbolIds != null && !otherRestrictedSymbolIds.contains(otherSym.getID())) continue;
                    ExternalLocation otherExtLoc = otherExtMgr.getExternalLocation(otherSym);
                    ExternalMatchType matchType = SimpleDiffUtility.testExternalMatch(otherExtLoc, extLoc);
                    refMatch = new ExternalReferenceCount(otherExtLoc, matchType);
                    if (matchType != ExternalMatchType.NONE) {
                        refMatch.setRelativeRank(targetAddr, targetNamespace, targetName, targetOrigImportedName);
                    }
                    matchesMap.put(otherExtAddr, refMatch);
                } else {
                    ++refMatch.refCount;
                }
                if (++totalMatchCnt != 20) continue;
                break;
            }
            if (extLoc.isFunction() && (thunkAddrs = extLoc.getFunction().getFunctionThunkAddresses()) != null) {
                for (Address thunkAddr : thunkAddrs) {
                    Function otherFunc;
                    Function otherThunkedFunc;
                    Symbol otherThunkSym = otherSymbMgr.getPrimarySymbol(thunkAddr);
                    if (otherThunkSym == null || otherThunkSym.getSymbolType() != SymbolType.FUNCTION || (otherThunkedFunc = (otherFunc = (Function)otherThunkSym.getObject()).getThunkedFunction(false)) == null || !otherThunkedFunc.isExternal()) continue;
                    ExternalReferenceCount refMatch = (ExternalReferenceCount)matchesMap.get(otherThunkedFunc.getEntryPoint());
                    if (refMatch == null) {
                        if (otherRestrictedSymbolIds != null && !otherRestrictedSymbolIds.contains(otherThunkedFunc.getID())) continue;
                        ExternalLocation otherExtLoc = otherExtMgr.getExternalLocation(otherThunkedFunc.getSymbol());
                        ExternalMatchType matchType = SimpleDiffUtility.testExternalMatch(otherExtLoc, extLoc);
                        refMatch = new ExternalReferenceCount(otherExtLoc, matchType);
                        if (matchType != ExternalMatchType.NONE) {
                            refMatch.setRelativeRank(targetAddr, targetNamespace, targetName, targetOrigImportedName);
                        }
                        matchesMap.put(otherThunkedFunc.getEntryPoint(), refMatch);
                        continue;
                    }
                    ++refMatch.refCount;
                }
            }
        }
        if (matchesMap.isEmpty()) {
            for (Symbol otherSym : otherSymbMgr.getExternalSymbols()) {
                ExternalMatchType matchType;
                ExternalLocation otherExtLoc;
                if (otherRestrictedSymbolIds != null && !otherRestrictedSymbolIds.contains(otherSym.getID()) || (otherExtLoc = otherExtMgr.getExternalLocation(otherSym)) == null || (matchType = SimpleDiffUtility.testExternalMatch(otherExtLoc, extLoc)) == ExternalMatchType.NONE) continue;
                ExternalReferenceCount refMatch = new ExternalReferenceCount(otherExtLoc, matchType);
                refMatch.setRelativeRank(targetAddr, targetNamespace, targetName, targetOrigImportedName);
                matchesMap.put(otherSym.getAddress(), refMatch);
            }
            if (matchesMap.isEmpty()) {
                return null;
            }
        }
        if ((matches = matchesMap.values().toArray(new ExternalReferenceCount[matchesMap.size()])).length == 1) {
            return ((ExternalReferenceCount)matches[0]).rank >= 0 ? ((ExternalReferenceCount)matches[0]).getSymbol() : null;
        }
        Arrays.sort(matches);
        return ((ExternalReferenceCount)matches[0]).rank > 0 ? ((ExternalReferenceCount)matches[0]).getSymbol() : null;
    }

    public static ExternalLocation getMatchingExternalLocation(Program program, ExternalLocation externalLocation, Program otherProgram, boolean allowInferredMatch) {
        if (externalLocation == null) {
            return null;
        }
        Symbol symbol = externalLocation.getSymbol();
        if (symbol == null) {
            return null;
        }
        Symbol matchingExternalSymbol = SimpleDiffUtility.getMatchingExternalSymbol(program, symbol, otherProgram, allowInferredMatch, null);
        if (matchingExternalSymbol == null) {
            return null;
        }
        ExternalManager otherExternalManager = otherProgram.getExternalManager();
        return otherExternalManager.getExternalLocation(matchingExternalSymbol);
    }

    public static Symbol getVariableSymbol(Symbol symbol, Program otherProgram) {
        Symbol otherParent = SimpleDiffUtility.getSymbol(symbol.getParentSymbol(), otherProgram);
        Namespace namespace = otherParent == null ? null : (Namespace)otherParent.getObject();
        return SimpleDiffUtility.getVariableSymbol(symbol, otherProgram, namespace);
    }

    protected static Symbol getVariableSymbol(Symbol varSym, Program otherProgram, Namespace otherNamespace) {
        if (!(otherNamespace instanceof Function)) {
            return null;
        }
        Program program = varSym.getProgram();
        SymbolTable otherSymTable = otherProgram.getSymbolTable();
        Variable var = (Variable)varSym.getObject();
        VariableStorage otherStorage = SimpleDiffUtility.getCompatibleVariableStorage(program, var.getVariableStorage(), otherProgram);
        if (otherStorage == null || otherStorage.isBadStorage()) {
            return null;
        }
        Variable minVar = SimpleDiffUtility.getOverlappingVariable(otherSymTable, var, otherStorage, otherNamespace.getSymbol());
        if (minVar != null) {
            return minVar.getSymbol();
        }
        return null;
    }

    protected static Symbol getVariableSymbol(Symbol varSym, Function otherFunction) {
        Program program = varSym.getProgram();
        Program otherProgram = otherFunction.getProgram();
        SymbolTable otherSymTable = otherProgram.getSymbolTable();
        Variable var = (Variable)varSym.getObject();
        Symbol otherFuncSym = otherFunction.getSymbol();
        if (otherFuncSym == null || otherFuncSym.getSymbolType() != SymbolType.FUNCTION) {
            return null;
        }
        VariableStorage storage = SimpleDiffUtility.getCompatibleVariableStorage(program, var.getVariableStorage(), otherProgram);
        if (storage == null || storage.isBadStorage()) {
            return null;
        }
        Variable minVar = SimpleDiffUtility.getOverlappingVariable(otherSymTable, var, storage, otherFuncSym);
        if (minVar != null) {
            return minVar.getSymbol();
        }
        return null;
    }

    protected static Variable getOverlappingVariable(SymbolTable otherSymTable, Variable var, VariableStorage otherStorage, Symbol otherFunctionSymbol) {
        SymbolType symbolType = var.getSymbol().getSymbolType();
        int ordinal = -1;
        if (var instanceof Parameter) {
            ordinal = ((Parameter)var).getOrdinal();
        }
        int firstUseOffset = var.getFirstUseOffset();
        SymbolIterator symbolIter = otherSymTable.getSymbols(otherFunctionSymbol.getID());
        while (symbolIter.hasNext()) {
            Variable v;
            Symbol s = symbolIter.next();
            if (s.getSymbolType() != symbolType || (v = (Variable)s.getObject()) instanceof Parameter && ordinal != ((Parameter)v).getOrdinal() || firstUseOffset != v.getFirstUseOffset() || !v.getVariableStorage().equals(otherStorage)) continue;
            return v;
        }
        return null;
    }

    private static enum ExternalMatchType {
        NONE,
        NAME,
        MANGLED_NAME,
        ADDRESS;

    }

    private static class ExternalReferenceCount
    implements Comparable<ExternalReferenceCount> {
        static final int ADDRESS_RANK = 3;
        static final int NAME_RANK = 2;
        static final int NAMESPACE_RANK = 1;
        static final int MANGLED_NAME_RANK = 3;
        final ExternalLocation extLoc;
        final ExternalMatchType matchType;
        int refCount = 1;
        int rank;

        ExternalReferenceCount(ExternalLocation extLoc, ExternalMatchType matchType) {
            this.extLoc = extLoc;
            this.matchType = matchType;
        }

        ExternalLocation getExternalLocation() {
            return this.extLoc;
        }

        Symbol getSymbol() {
            return this.extLoc.getSymbol();
        }

        SymbolType getSymbolType() {
            return this.getSymbol().getSymbolType();
        }

        String getSymbolName() {
            return this.getSymbol().getName();
        }

        String getFullNamespaceName() {
            return this.getSymbol().getParentNamespace().getName(true);
        }

        @Override
        public int compareTo(ExternalReferenceCount other) {
            int diff = other.rank - this.rank;
            if (diff != 0) {
                return diff;
            }
            diff = other.refCount - this.refCount;
            if (diff != 0) {
                return diff;
            }
            diff = other.getSymbolType().getID() - this.getSymbolType().getID();
            if (diff != 0) {
                return diff;
            }
            return this.getSymbol().getName(true).compareTo(other.getSymbol().getName(true));
        }

        void setRelativeRank(Address targetAddr, String targetNamespace, String targetName, String targetOrigImportedName) {
            this.rank = 0;
            if (this.matchType == ExternalMatchType.ADDRESS) {
                this.rank = 3;
                return;
            }
            if (targetAddr != null) {
                Address myAddr = this.extLoc.getAddress();
                if (myAddr != null && targetAddr.equals(myAddr)) {
                    this.rank += 3;
                } else if (myAddr != null) {
                    this.rank -= 3;
                }
            }
            if (this.matchType == ExternalMatchType.MANGLED_NAME) {
                this.rank += 3;
                return;
            }
            if (this.matchType != ExternalMatchType.NAME) {
                return;
            }
            String myOrigImportedName = this.extLoc.getOriginalImportedName();
            if (targetOrigImportedName != null && myOrigImportedName != null) {
                this.rank -= 3;
                return;
            }
            this.rank += 2;
            if (targetNamespace != null && targetNamespace.equals(this.getFullNamespaceName())) {
                ++this.rank;
            }
        }
    }
}

