/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.AbstractAddressSetView;
import ghidra.util.AddressRangeIterators;
import java.util.Iterator;

public class DifferenceAddressSetView
extends AbstractAddressSetView {
    private final AddressSetView a;
    private final AddressSetView b;

    public DifferenceAddressSetView(AddressSetView a, AddressSetView b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public boolean contains(Address addr) {
        return this.a.contains(addr) && !this.b.contains(addr);
    }

    @Override
    public boolean contains(Address start, Address end) {
        return this.a.contains(start, end) && !this.b.intersects(start, end);
    }

    @Override
    public boolean contains(AddressSetView rangeSet) {
        return this.a.contains(rangeSet) && !this.b.intersects(rangeSet);
    }

    @Override
    public AddressRangeIterator getAddressRanges() {
        return AddressRangeIterators.subtract(this.a.iterator(), this.b.iterator(), null, true);
    }

    @Override
    public AddressRangeIterator getAddressRanges(boolean forward) {
        return AddressRangeIterators.subtract(this.a.iterator(forward), this.b.iterator(forward), null, forward);
    }

    @Override
    public AddressRangeIterator getAddressRanges(Address start, boolean forward) {
        Iterator<AddressRange> rev = this.b.iterator(start, !forward);
        Address bStart = rev.hasNext() ? (forward ? rev.next().getMinAddress() : rev.next().getMaxAddress()) : start;
        return AddressRangeIterators.subtract(this.a.iterator(start, forward), this.b.iterator(bStart, forward), start, forward);
    }

    static AddressRange truncate(AddressRange rng, Address address, AddressSetView v) {
        boolean truncNext;
        AddressRangeIterator prevIt = v.getAddressRanges(address, false);
        AddressRange prev = prevIt.hasNext() ? (AddressRange)prevIt.next() : null;
        AddressRangeIterator nextIt = v.getAddressRanges(address, true);
        AddressRange next = nextIt.hasNext() ? (AddressRange)nextIt.next() : null;
        boolean truncPrev = prev != null && prev.intersects(rng);
        boolean bl = truncNext = next != null && next.intersects(rng);
        if (!truncPrev && !truncNext) {
            return rng;
        }
        Address min = truncPrev ? prev.getMaxAddress().next() : rng.getMinAddress();
        Address max = truncNext ? next.getMinAddress().previous() : rng.getMaxAddress();
        return new AddressRangeImpl(min, max);
    }

    @Override
    public AddressRange getRangeContaining(Address address) {
        AddressRange rng = this.a.getRangeContaining(address);
        if (rng == null) {
            return null;
        }
        AddressRange sub = this.b.getRangeContaining(address);
        if (sub != null) {
            return null;
        }
        return DifferenceAddressSetView.truncate(rng, address, this.b);
    }
}

