/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.javaclass.format.FieldInfoJava;
import ghidra.javaclass.format.MethodInfoJava;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.javaclass.format.attributes.AttributeFactory;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.javaclass.format.constantpool.ConstantPoolDoubleInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolFactory;
import ghidra.javaclass.format.constantpool.ConstantPoolLongInfo;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ClassFileJava
implements StructConverter {
    private int magic;
    private short minorVersion;
    private short majorVersion;
    private short constantPoolCount;
    private AbstractConstantPoolInfoJava[] constantPool;
    private short accessFlags;
    private short thisClass;
    private short superClass;
    private short interfacesCount;
    private short[] interfaces;
    private short fieldsCount;
    private FieldInfoJava[] fields;
    private short methodsCount;
    private MethodInfoJava[] methods;
    private short attributesCount;
    private AbstractAttributeInfo[] attributes;

    public ClassFileJava(BinaryReader reader) throws IOException {
        int i;
        this.magic = reader.readNextInt();
        if (this.magic != -889275714) {
            throw new IOException("Invalid Java Class File.");
        }
        this.minorVersion = reader.readNextShort();
        this.majorVersion = reader.readNextShort();
        this.constantPoolCount = reader.readNextShort();
        this.constantPool = new AbstractConstantPoolInfoJava[this.getConstantPoolCount()];
        for (i = 1; i < this.getConstantPoolCount(); ++i) {
            this.constantPool[i] = ConstantPoolFactory.get(reader);
            if (!(this.constantPool[i] instanceof ConstantPoolLongInfo) && !(this.constantPool[i] instanceof ConstantPoolDoubleInfo)) continue;
            ++i;
        }
        this.accessFlags = reader.readNextShort();
        this.thisClass = reader.readNextShort();
        this.superClass = reader.readNextShort();
        this.interfacesCount = reader.readNextShort();
        this.interfaces = reader.readNextShortArray(this.getInterfacesCount());
        this.fieldsCount = reader.readNextShort();
        this.fields = new FieldInfoJava[this.getFieldsCount()];
        for (i = 0; i < this.getFieldsCount(); ++i) {
            this.fields[i] = new FieldInfoJava(reader, this);
        }
        this.methodsCount = reader.readNextShort();
        this.methods = new MethodInfoJava[this.getMethodsCount()];
        for (i = 0; i < this.getMethodsCount(); ++i) {
            this.methods[i] = new MethodInfoJava(reader, this);
        }
        this.attributesCount = reader.readNextShort();
        this.attributes = new AbstractAttributeInfo[this.getAttributesCount()];
        for (i = 0; i < this.getAttributesCount(); ++i) {
            this.attributes[i] = AttributeFactory.get(reader, this.getConstantPool());
        }
    }

    public int getMagic() {
        return this.magic;
    }

    public short getMinorVersion() {
        return this.minorVersion;
    }

    public short getMajorVersion() {
        return this.majorVersion;
    }

    public int getConstantPoolCount() {
        return this.constantPoolCount & 0xFFFF;
    }

    public AbstractConstantPoolInfoJava[] getConstantPool() {
        return this.constantPool;
    }

    public short getAccessFlags() {
        return this.accessFlags;
    }

    public int getThisClass() {
        return this.thisClass & 0xFFFF;
    }

    public int getSuperClass() {
        return this.superClass & 0xFFFF;
    }

    public int getInterfacesCount() {
        return this.interfacesCount & 0xFFFF;
    }

    public int getInterfacesEntry(int i) {
        return this.interfaces[i] & 0xFFFF;
    }

    public int getFieldsCount() {
        return this.fieldsCount & 0xFFFF;
    }

    public FieldInfoJava[] getFields() {
        return this.fields;
    }

    public int getMethodsCount() {
        return this.methodsCount & 0xFFFF;
    }

    public MethodInfoJava[] getMethods() {
        return this.methods;
    }

    public int getAttributesCount() {
        return this.attributesCount & 0xFFFF;
    }

    public AbstractAttributeInfo[] getAttributes() {
        return this.attributes;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        int i;
        String name = "ClassFile";
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add(DWORD, "magic", null);
        structure.add(WORD, "minor_version", null);
        structure.add(WORD, "major_version", null);
        structure.add(WORD, "constant_pool_count", null);
        StructureDataType constantPoolStruct = new StructureDataType("constant_pool", 0);
        for (int i2 = 0; i2 < this.constantPool.length; ++i2) {
            if (this.constantPool[i2] == null) continue;
            constantPoolStruct.add(this.constantPool[i2].toDataType(), "constant_pool_0x" + Integer.toHexString(i2), null);
        }
        structure.add((DataType)constantPoolStruct, "constant_pool", null);
        structure.add(WORD, "access_flags", null);
        structure.add(WORD, "this_class", null);
        structure.add(WORD, "super_class", null);
        structure.add(WORD, "interfaces_count", null);
        if (this.getInterfacesCount() > 0) {
            ArrayDataType array = new ArrayDataType(WORD, this.getInterfacesCount(), WORD.getLength());
            structure.add((DataType)array, "interfaces", null);
        }
        structure.add(WORD, "field_count", null);
        if (this.getFieldsCount() > 0) {
            StructureDataType fieldStruct = new StructureDataType("fields", 0);
            for (i = 0; i < this.fields.length; ++i) {
                fieldStruct.add(this.fields[i].toDataType(), "field_" + i, null);
            }
            structure.add((DataType)fieldStruct, "fields", null);
        }
        structure.add(WORD, "method_count", null);
        if (this.getMethodsCount() > 0) {
            StructureDataType methodsStruct = new StructureDataType("methods", 0);
            for (i = 0; i < this.methods.length; ++i) {
                methodsStruct.add(this.methods[i].toDataType(), "methods_" + i, null);
            }
            structure.add((DataType)methodsStruct, "methods", null);
        }
        structure.add(WORD, "attributes_count", null);
        if (this.getAttributesCount() > 0) {
            StructureDataType attributesStruct = new StructureDataType("attributes", 0);
            for (i = 0; i < this.attributes.length; ++i) {
                attributesStruct.add(this.attributes[i].toDataType(), "attributes_" + i, null);
            }
            structure.add((DataType)attributesStruct, "attributes", null);
        }
        return structure;
    }
}

