/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.javaclass.format.attributes.MethodParameters;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class MethodParametersAttribute
extends AbstractAttributeInfo {
    private byte parameters_count;
    private MethodParameters[] parameters;

    protected MethodParametersAttribute(BinaryReader reader) throws IOException {
        super(reader);
        this.parameters_count = reader.readNextByte();
        int size = Byte.toUnsignedInt(this.parameters_count);
        this.parameters = new MethodParameters[size];
        for (int i = 0; i < size; ++i) {
            this.parameters[i] = new MethodParameters(reader);
        }
    }

    public MethodParameters[] getMethodParameters() {
        return this.parameters;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = this.getBaseStructure("MethodParameters_attribute");
        structure.add(BYTE, "num_parameters", null);
        for (int i = 0; i < this.parameters.length; ++i) {
            structure.add(this.parameters[i].toDataType(), "parameter" + i, null);
        }
        return structure;
    }
}

