/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.taint;

import ghidra.pcode.emu.DefaultPcodeThread;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.emu.auxiliary.AuxEmulatorPartsFactory;
import ghidra.pcode.emu.auxiliary.AuxPcodeEmulator;
import ghidra.pcode.emu.taint.TaintPcodeArithmetic;
import ghidra.pcode.emu.taint.TaintPcodeThreadExecutor;
import ghidra.pcode.emu.taint.TaintPcodeUseropLibrary;
import ghidra.pcode.emu.taint.state.TaintPcodeExecutorState;
import ghidra.pcode.exec.BytesPcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeStateCallbacks;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.lang.Language;
import ghidra.taint.model.TaintVec;
import org.apache.commons.lang3.tuple.Pair;

public enum TaintPartsFactory implements AuxEmulatorPartsFactory<TaintVec>
{
    INSTANCE;


    public PcodeArithmetic<TaintVec> getArithmetic(Language language) {
        return TaintPcodeArithmetic.forLanguage(language);
    }

    public PcodeUseropLibrary<Pair<byte[], TaintVec>> createSharedUseropLibrary(AuxPcodeEmulator<TaintVec> emulator) {
        return new TaintPcodeUseropLibrary();
    }

    public PcodeUseropLibrary<Pair<byte[], TaintVec>> createLocalUseropStub(AuxPcodeEmulator<TaintVec> emulator) {
        return PcodeUseropLibrary.nil();
    }

    public PcodeUseropLibrary<Pair<byte[], TaintVec>> createLocalUseropLibrary(AuxPcodeEmulator<TaintVec> emulator, PcodeThread<Pair<byte[], TaintVec>> thread) {
        return PcodeUseropLibrary.nil();
    }

    public DefaultPcodeThread.PcodeThreadExecutor<Pair<byte[], TaintVec>> createExecutor(AuxPcodeEmulator<TaintVec> emulator, DefaultPcodeThread<Pair<byte[], TaintVec>> thread) {
        return new TaintPcodeThreadExecutor(thread);
    }

    public PcodeExecutorState<Pair<byte[], TaintVec>> createSharedState(AuxPcodeEmulator<TaintVec> emulator, BytesPcodeExecutorStatePiece concrete, PcodeStateCallbacks cb) {
        return new TaintPcodeExecutorState((Language)emulator.getLanguage(), concrete, cb);
    }

    public PcodeExecutorState<Pair<byte[], TaintVec>> createLocalState(AuxPcodeEmulator<TaintVec> emulator, PcodeThread<Pair<byte[], TaintVec>> thread, BytesPcodeExecutorStatePiece concrete, PcodeStateCallbacks cb) {
        return new TaintPcodeExecutorState((Language)emulator.getLanguage(), concrete, cb);
    }
}

