/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.sarif;

import com.contrastsecurity.sarif.Location;
import com.contrastsecurity.sarif.PropertyBag;
import com.contrastsecurity.sarif.ReportingDescriptorReference;
import com.contrastsecurity.sarif.Stack;
import com.contrastsecurity.sarif.State;
import com.contrastsecurity.sarif.WebRequest;
import com.contrastsecurity.sarif.WebResponse;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"index", "location", "stack", "kinds", "taxa", "module", "state", "nestingLevel", "executionOrder", "executionTimeUtc", "importance", "webRequest", "webResponse", "properties"})
public class ThreadFlowLocation {
    @JsonProperty(value="index")
    @JsonPropertyDescription(value="The index within the run threadFlowLocations array.")
    private Long index = -1L;
    @JsonProperty(value="location")
    @JsonPropertyDescription(value="A location within a programming artifact.")
    private Location location;
    @JsonProperty(value="stack")
    @JsonPropertyDescription(value="A call stack that is relevant to a result.")
    private Stack stack;
    @JsonProperty(value="kinds")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="A set of distinct strings that categorize the thread flow location. Well-known kinds include 'acquire', 'release', 'enter', 'exit', 'call', 'return', 'branch', 'implicit', 'false', 'true', 'caution', 'danger', 'unknown', 'unreachable', 'taint', 'function', 'handler', 'lock', 'memory', 'resource', 'scope' and 'value'.")
    private Set<String> kinds = null;
    @JsonProperty(value="taxa")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="An array of references to rule or taxonomy reporting descriptors that are applicable to the thread flow location.")
    private Set<ReportingDescriptorReference> taxa = null;
    @JsonProperty(value="module")
    @JsonPropertyDescription(value="The name of the module that contains the code that is executing.")
    private String module;
    @JsonProperty(value="state")
    @JsonPropertyDescription(value="A dictionary, each of whose keys specifies a variable or expression, the associated value of which represents the variable or expression value. For an annotation of kind 'continuation', for example, this dictionary might hold the current assumed values of a set of global variables.")
    private State state;
    @JsonProperty(value="nestingLevel")
    @JsonPropertyDescription(value="An integer representing a containment hierarchy within the thread flow.")
    private Long nestingLevel;
    @JsonProperty(value="executionOrder")
    @JsonPropertyDescription(value="An integer representing the temporal order in which execution reached this location.")
    private Long executionOrder = -1L;
    @JsonProperty(value="executionTimeUtc")
    @JsonPropertyDescription(value="The Coordinated Universal Time (UTC) date and time at which this location was executed.")
    private Date executionTimeUtc;
    @JsonProperty(value="importance")
    @JsonPropertyDescription(value="Specifies the importance of this location in understanding the code flow in which it occurs. The order from most to least important is \"essential\", \"important\", \"unimportant\". Default: \"important\".")
    private Importance importance = Importance.fromValue("important");
    @JsonProperty(value="webRequest")
    @JsonPropertyDescription(value="Describes an HTTP request.")
    private WebRequest webRequest;
    @JsonProperty(value="webResponse")
    @JsonPropertyDescription(value="Describes the response to an HTTP request.")
    private WebResponse webResponse;
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="index")
    public Long getIndex() {
        return this.index;
    }

    @JsonProperty(value="index")
    public void setIndex(Long index) {
        this.index = index;
    }

    public ThreadFlowLocation withIndex(Long index) {
        this.index = index;
        return this;
    }

    @JsonProperty(value="location")
    public Location getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    public void setLocation(Location location) {
        this.location = location;
    }

    public ThreadFlowLocation withLocation(Location location) {
        this.location = location;
        return this;
    }

    @JsonProperty(value="stack")
    public Stack getStack() {
        return this.stack;
    }

    @JsonProperty(value="stack")
    public void setStack(Stack stack) {
        this.stack = stack;
    }

    public ThreadFlowLocation withStack(Stack stack) {
        this.stack = stack;
        return this;
    }

    @JsonProperty(value="kinds")
    public Set<String> getKinds() {
        return this.kinds;
    }

    @JsonProperty(value="kinds")
    public void setKinds(Set<String> kinds) {
        this.kinds = kinds;
    }

    public ThreadFlowLocation withKinds(Set<String> kinds) {
        this.kinds = kinds;
        return this;
    }

    @JsonProperty(value="taxa")
    public Set<ReportingDescriptorReference> getTaxa() {
        return this.taxa;
    }

    @JsonProperty(value="taxa")
    public void setTaxa(Set<ReportingDescriptorReference> taxa) {
        this.taxa = taxa;
    }

    public ThreadFlowLocation withTaxa(Set<ReportingDescriptorReference> taxa) {
        this.taxa = taxa;
        return this;
    }

    @JsonProperty(value="module")
    public String getModule() {
        return this.module;
    }

    @JsonProperty(value="module")
    public void setModule(String module) {
        this.module = module;
    }

    public ThreadFlowLocation withModule(String module) {
        this.module = module;
        return this;
    }

    @JsonProperty(value="state")
    public State getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    public void setState(State state) {
        this.state = state;
    }

    public ThreadFlowLocation withState(State state) {
        this.state = state;
        return this;
    }

    @JsonProperty(value="nestingLevel")
    public Long getNestingLevel() {
        return this.nestingLevel;
    }

    @JsonProperty(value="nestingLevel")
    public void setNestingLevel(Long nestingLevel) {
        this.nestingLevel = nestingLevel;
    }

    public ThreadFlowLocation withNestingLevel(Long nestingLevel) {
        this.nestingLevel = nestingLevel;
        return this;
    }

    @JsonProperty(value="executionOrder")
    public Long getExecutionOrder() {
        return this.executionOrder;
    }

    @JsonProperty(value="executionOrder")
    public void setExecutionOrder(Long executionOrder) {
        this.executionOrder = executionOrder;
    }

    public ThreadFlowLocation withExecutionOrder(Long executionOrder) {
        this.executionOrder = executionOrder;
        return this;
    }

    @JsonProperty(value="executionTimeUtc")
    public Date getExecutionTimeUtc() {
        return this.executionTimeUtc;
    }

    @JsonProperty(value="executionTimeUtc")
    public void setExecutionTimeUtc(Date executionTimeUtc) {
        this.executionTimeUtc = executionTimeUtc;
    }

    public ThreadFlowLocation withExecutionTimeUtc(Date executionTimeUtc) {
        this.executionTimeUtc = executionTimeUtc;
        return this;
    }

    @JsonProperty(value="importance")
    public Importance getImportance() {
        return this.importance;
    }

    @JsonProperty(value="importance")
    public void setImportance(Importance importance) {
        this.importance = importance;
    }

    public ThreadFlowLocation withImportance(Importance importance) {
        this.importance = importance;
        return this;
    }

    @JsonProperty(value="webRequest")
    public WebRequest getWebRequest() {
        return this.webRequest;
    }

    @JsonProperty(value="webRequest")
    public void setWebRequest(WebRequest webRequest) {
        this.webRequest = webRequest;
    }

    public ThreadFlowLocation withWebRequest(WebRequest webRequest) {
        this.webRequest = webRequest;
        return this;
    }

    @JsonProperty(value="webResponse")
    public WebResponse getWebResponse() {
        return this.webResponse;
    }

    @JsonProperty(value="webResponse")
    public void setWebResponse(WebResponse webResponse) {
        this.webResponse = webResponse;
    }

    public ThreadFlowLocation withWebResponse(WebResponse webResponse) {
        this.webResponse = webResponse;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public ThreadFlowLocation withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ThreadFlowLocation.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("index");
        sb.append('=');
        sb.append(this.index == null ? "<null>" : this.index);
        sb.append(',');
        sb.append("location");
        sb.append('=');
        sb.append(this.location == null ? "<null>" : this.location);
        sb.append(',');
        sb.append("stack");
        sb.append('=');
        sb.append(this.stack == null ? "<null>" : this.stack);
        sb.append(',');
        sb.append("kinds");
        sb.append('=');
        sb.append(this.kinds == null ? "<null>" : this.kinds);
        sb.append(',');
        sb.append("taxa");
        sb.append('=');
        sb.append(this.taxa == null ? "<null>" : this.taxa);
        sb.append(',');
        sb.append("module");
        sb.append('=');
        sb.append(this.module == null ? "<null>" : this.module);
        sb.append(',');
        sb.append("state");
        sb.append('=');
        sb.append(this.state == null ? "<null>" : this.state);
        sb.append(',');
        sb.append("nestingLevel");
        sb.append('=');
        sb.append(this.nestingLevel == null ? "<null>" : this.nestingLevel);
        sb.append(',');
        sb.append("executionOrder");
        sb.append('=');
        sb.append(this.executionOrder == null ? "<null>" : this.executionOrder);
        sb.append(',');
        sb.append("executionTimeUtc");
        sb.append('=');
        sb.append(this.executionTimeUtc == null ? "<null>" : this.executionTimeUtc);
        sb.append(',');
        sb.append("importance");
        sb.append('=');
        sb.append(this.importance == null ? "<null>" : this.importance);
        sb.append(',');
        sb.append("webRequest");
        sb.append('=');
        sb.append(this.webRequest == null ? "<null>" : this.webRequest);
        sb.append(',');
        sb.append("webResponse");
        sb.append('=');
        sb.append(this.webResponse == null ? "<null>" : this.webResponse);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.taxa == null ? 0 : this.taxa.hashCode());
        result = result * 31 + (this.nestingLevel == null ? 0 : this.nestingLevel.hashCode());
        result = result * 31 + (this.stack == null ? 0 : this.stack.hashCode());
        result = result * 31 + (this.webRequest == null ? 0 : this.webRequest.hashCode());
        result = result * 31 + (this.importance == null ? 0 : this.importance.hashCode());
        result = result * 31 + (this.module == null ? 0 : this.module.hashCode());
        result = result * 31 + (this.executionTimeUtc == null ? 0 : this.executionTimeUtc.hashCode());
        result = result * 31 + (this.index == null ? 0 : this.index.hashCode());
        result = result * 31 + (this.kinds == null ? 0 : this.kinds.hashCode());
        result = result * 31 + (this.executionOrder == null ? 0 : this.executionOrder.hashCode());
        result = result * 31 + (this.webResponse == null ? 0 : this.webResponse.hashCode());
        result = result * 31 + (this.location == null ? 0 : this.location.hashCode());
        result = result * 31 + (this.state == null ? 0 : this.state.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ThreadFlowLocation)) {
            return false;
        }
        ThreadFlowLocation rhs = (ThreadFlowLocation)other;
        return (this.taxa == rhs.taxa || this.taxa != null && this.taxa.equals(rhs.taxa)) && (this.nestingLevel == rhs.nestingLevel || this.nestingLevel != null && this.nestingLevel.equals(rhs.nestingLevel)) && (this.stack == rhs.stack || this.stack != null && this.stack.equals(rhs.stack)) && (this.webRequest == rhs.webRequest || this.webRequest != null && this.webRequest.equals(rhs.webRequest)) && (this.importance == rhs.importance || this.importance != null && this.importance.equals((Object)rhs.importance)) && (this.module == rhs.module || this.module != null && this.module.equals(rhs.module)) && (this.executionTimeUtc == rhs.executionTimeUtc || this.executionTimeUtc != null && this.executionTimeUtc.equals(rhs.executionTimeUtc)) && (this.index == rhs.index || this.index != null && this.index.equals(rhs.index)) && (this.kinds == rhs.kinds || this.kinds != null && this.kinds.equals(rhs.kinds)) && (this.executionOrder == rhs.executionOrder || this.executionOrder != null && this.executionOrder.equals(rhs.executionOrder)) && (this.webResponse == rhs.webResponse || this.webResponse != null && this.webResponse.equals(rhs.webResponse)) && (this.location == rhs.location || this.location != null && this.location.equals(rhs.location)) && (this.state == rhs.state || this.state != null && this.state.equals(rhs.state)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties));
    }

    public static enum Importance {
        IMPORTANT("important"),
        ESSENTIAL("essential"),
        UNIMPORTANT("unimportant");

        private final String value;
        private static final Map<String, Importance> CONSTANTS;

        private Importance(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Importance fromValue(String value) {
            Importance constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Importance>();
            for (Importance c : Importance.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

