/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.address;

import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.util.AddressCorrelation;
import ghidra.program.util.AddressCorrelator;
import ghidra.program.util.LinearDataAddressCorrelation;
import ghidra.program.util.LinearFunctionAddressCorrelation;

public class LinearAddressCorrelator
implements AddressCorrelator {
    private static final String CORRELATOR_NAME = "LastResortAddressCorrelator";
    private ToolOptions options = new ToolOptions("LastResortAddressCorrelator");

    public AddressCorrelation correlate(Function sourceFunction, Function destinationFunction) {
        return new LinearFunctionAddressCorrelation(sourceFunction, destinationFunction);
    }

    public AddressCorrelation correlate(Data sourceData, Data destinationData) {
        return new LinearDataAddressCorrelation(sourceData, destinationData);
    }

    public ToolOptions getOptions() {
        return this.options;
    }

    public void setOptions(ToolOptions options) {
        this.options = options.copy();
    }

    public Options getDefaultOptions() {
        return new ToolOptions(CORRELATOR_NAME);
    }

    public int getPriority() {
        return 1000;
    }
}

