/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.address;

import ghidra.feature.vt.api.correlator.address.VTHashedFunctionAddressCorrelation;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.util.AddressCorrelation;
import ghidra.program.util.AddressCorrelator;

public class VTHashedFunctionAddressCorrelator
implements AddressCorrelator {
    public static final String NAME = "VTHashedFunctionAddressCorrelator";
    private ToolOptions options = new ToolOptions("VTHashedFunctionAddressCorrelator");

    public AddressCorrelation correlate(Function sourceFunction, Function destinationFunction) {
        Language sourceLanguage = sourceFunction.getProgram().getLanguage();
        Language destinationLanguage = destinationFunction.getProgram().getLanguage();
        if (sourceLanguage.getProcessor().equals((Object)destinationLanguage.getProcessor())) {
            return new VTHashedFunctionAddressCorrelation(sourceFunction, destinationFunction);
        }
        return null;
    }

    public AddressCorrelation correlate(Data sourceData, Data destinationData) {
        return null;
    }

    public ToolOptions getOptions() {
        return this.options;
    }

    public void setOptions(ToolOptions options) {
        this.options = options.copy();
    }

    public Options getDefaultOptions() {
        return new ToolOptions(NAME);
    }

    public int getPriority() {
        return 490;
    }
}

