/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.task;

import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemConsideredStatus;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class SetMarkupItemConsideredTask
extends Task {
    protected final List<VTMarkupItem> markupItems;
    private final VTSessionDB session;
    protected final VTMarkupItemConsideredStatus status;

    public SetMarkupItemConsideredTask(VTSession session, List<VTMarkupItem> markupItems, VTMarkupItemConsideredStatus status) {
        this(status.name() + " Markup Items", session, markupItems, status);
    }

    protected SetMarkupItemConsideredTask(String title, VTSession session, List<VTMarkupItem> markupItems, VTMarkupItemConsideredStatus status) {
        super(title, true, true, true, true);
        this.markupItems = markupItems;
        if (!(session instanceof VTSessionDB)) {
            throw new IllegalArgumentException("Unexpected condition - VTSession is not a DB object!");
        }
        this.session = (VTSessionDB)session;
        this.status = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) {
        boolean commit = true;
        int matchSetTransactionID = this.session.startTransaction(this.getTaskTitle());
        try {
            this.doWork(monitor);
        }
        catch (CancelledException e) {
            commit = false;
        }
        catch (Exception e) {
            commit = false;
            Msg.showError((Object)((Object)this), null, (String)"Unable to Apply Markup Item(s)", (Object)"An unexpected error occurred attempting to apply markup item(s).", (Throwable)e);
        }
        finally {
            this.session.endTransaction(matchSetTransactionID, commit);
        }
    }

    protected void doWork(TaskMonitor monitor) throws Exception, CancelledException {
        monitor.initialize((long)this.markupItems.size());
        for (VTMarkupItem markupItem : this.markupItems) {
            monitor.checkCancelled();
            markupItem.setConsidered(this.status);
            monitor.incrementProgress(1L);
        }
    }
}

