/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.security.KeyStore;
import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.rzo.yajsw.util.MyKeyStoreInterface;

public class MyKeyStore
implements MyKeyStoreInterface {
    private final KeyStore ks;
    private final AtomicReference<FileLock> lock = new AtomicReference();
    private final AtomicReference<FileChannel> channel = new AtomicReference();
    private String file;
    private final char[] pwd;

    public MyKeyStore(String file, char[] pwd) throws Exception {
        this.ks = KeyStore.getInstance("JCEKS");
        this.file = file;
        this.pwd = pwd;
    }

    public void init() throws Exception {
        File f = new File(this.file);
        if (!f.exists()) {
            this.createStore();
        } else {
            this.readStore();
        }
        this.lockFile();
    }

    public void start() throws Exception {
        String newFile = String.valueOf(this.file) + ".xxx";
        if (!new File(this.file).exists() && !new File(newFile).exists()) {
            throw new RuntimeException("keystore not found: " + new File(this.file).getAbsolutePath());
        }
        if (!new File(newFile).exists()) {
            new File(this.file).renameTo(new File(newFile));
            this.file = newFile;
            this.restrictAccess();
        }
        this.file = newFile;
        if (!new File(this.file).exists()) {
            throw new RuntimeException("keystore not found: " + new File(this.file).getAbsolutePath());
        }
        this.init();
    }

    public MyKeyStore() throws Exception {
        this("keystore", MyKeyStore.class.getName().toCharArray());
    }

    public MyKeyStore(String file) throws Exception {
        this(file, MyKeyStore.class.getName().toCharArray());
    }

    private void lockFile() throws Exception {
        this.channel.set(new RandomAccessFile(this.file, "rw").getChannel());
        this.lock.set(this.channel.get().lock());
    }

    private void readStore() throws Exception {
        FileInputStream fIn = new FileInputStream(this.file);
        this.ks.load(fIn, this.pwd);
        fIn.close();
    }

    public void put(String key, char[] text) throws Exception {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBE");
        SecretKey generatedSecret = factory.generateSecret(new PBEKeySpec(text));
        KeyStore.PasswordProtection keyStorePP = new KeyStore.PasswordProtection(this.pwd);
        this.ks.setEntry(key, new KeyStore.SecretKeyEntry(generatedSecret), keyStorePP);
        OutputStream out = Channels.newOutputStream(this.channel.get());
        this.ks.store(out, this.pwd);
        this.lockFile();
    }

    public char[] get(String key) throws Exception {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBE");
        KeyStore.PasswordProtection keyStorePP = new KeyStore.PasswordProtection(this.pwd);
        KeyStore.SecretKeyEntry ske = (KeyStore.SecretKeyEntry)this.ks.getEntry(key, keyStorePP);
        PBEKeySpec keySpec = (PBEKeySpec)factory.getKeySpec(ske.getSecretKey(), PBEKeySpec.class);
        return keySpec.getPassword();
    }

    private void createStore() throws Exception {
        this.ks.load(null, this.pwd);
        new File(this.file).createNewFile();
        FileOutputStream fos = new FileOutputStream(this.file);
        this.ks.store(fos, this.pwd);
        fos.close();
    }

    private void restrictAccess() throws Exception {
        UserPrincipal user = this.getDefaultFileOwner();
        Path path = Paths.get(this.file, new String[0]);
        AclFileAttributeView aclAttr = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
        System.out.println("owner: " + aclAttr.getOwner());
        UserPrincipalLookupService upls = path.getFileSystem().getUserPrincipalLookupService();
        AclEntry.Builder builder = AclEntry.newBuilder();
        builder.setPermissions(EnumSet.of(AclEntryPermission.READ_DATA, new AclEntryPermission[]{AclEntryPermission.WRITE_DATA, AclEntryPermission.APPEND_DATA, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.READ_ACL, AclEntryPermission.SYNCHRONIZE}));
        builder.setPrincipal(user);
        builder.setType(AclEntryType.ALLOW);
        aclAttr.setOwner(user);
        aclAttr.setAcl(Collections.singletonList(builder.build()));
    }

    private UserPrincipal getDefaultFileOwner() throws Exception {
        new File("x.tmp").createNewFile();
        Path path = Paths.get("x.tmp", new String[0]);
        AclFileAttributeView aclAttr = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
        UserPrincipal result = aclAttr.getOwner();
        new File("x.tmp").delete();
        return result;
    }

    public static void main(String[] args) throws Exception {
        MyKeyStore ks = new MyKeyStore("mykeystore2.dat", "test".toCharArray());
        while (true) {
            System.out.println(new String(ks.get("pwd1")));
            System.out.println(new String(ks.get("pwd2")));
            Thread.sleep(1000L);
        }
    }

    public String getFile() {
        return new File(this.file).getAbsolutePath();
    }
}

