/*
 * Decompiled with CFR 0.152.
 */
package datagraph.data.graph;

import datagraph.data.graph.DegController;
import datagraph.data.graph.DegVertex;
import datagraph.graph.explore.EgVertex;
import docking.action.DockingAction;
import ghidra.base.graph.CircleWithLabelVertexShapeProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import java.awt.Component;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class CodeDegVertex
extends DegVertex {
    private Instruction instruction;
    private CircleWithLabelVertexShapeProvider shapeProvider;

    public CodeDegVertex(DegController controller, Instruction instruction, DegVertex parent) {
        super(controller, parent);
        this.instruction = instruction;
        String label = this.getVertexLabel();
        this.shapeProvider = new CircleWithLabelVertexShapeProvider(label);
        this.shapeProvider.setTogglesVisible(false);
    }

    @Override
    public String getTitle() {
        return null;
    }

    public int hashCode() {
        return this.instruction.hashCode();
    }

    @Override
    public DegVertex.DegVertexStatus refreshGraph(boolean checkDataTypes) {
        return DegVertex.DegVertexStatus.VALID;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeDegVertex other = (CodeDegVertex)obj;
        return this.instruction.equals((Object)other.instruction);
    }

    private String getVertexLabel() {
        Address address = this.instruction.getAddress();
        Program program = this.instruction.getProgram();
        FunctionManager functionManager = program.getFunctionManager();
        Function f = functionManager.getFunctionContaining(address);
        if (f != null) {
            Object name = f.getName();
            if (!f.getEntryPoint().equals((Object)address)) {
                name = (String)name + " + " + address.subtract(f.getEntryPoint());
            }
            return name;
        }
        return address.toString();
    }

    @Override
    public void clearUserChangedLocation() {
        super.clearUserChangedLocation();
        this.controller.relayoutGraph();
    }

    public String toString() {
        return "Instruction @ " + this.instruction.getAddress().toString();
    }

    public Shape getCompactShape() {
        return this.shapeProvider.getCompactShape();
    }

    public Shape getFullShape() {
        return this.shapeProvider.getFullShape();
    }

    public JComponent getComponent() {
        return this.shapeProvider.getComponent();
    }

    @Override
    protected void addAction(DockingAction action) {
    }

    @Override
    public Address getAddress() {
        return this.instruction.getMinAddress();
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.controller.navigateOut(this.instruction.getAddress(), null);
    }

    @Override
    public CodeUnit getCodeUnit() {
        return this.instruction;
    }

    @Override
    public boolean isGrabbable(Component component) {
        return true;
    }

    @Override
    protected Point2D getStartingEdgePoint(EgVertex end) {
        Point2D location = this.getLocation();
        return new Point2D.Double(location.getX(), location.getY() + (double)this.shapeProvider.getCircleCenterYOffset());
    }

    @Override
    protected Point2D getEndingEdgePoint(EgVertex start) {
        Point2D location = this.getLocation();
        return new Point2D.Double(location.getX(), location.getY() + (double)this.shapeProvider.getCircleCenterYOffset());
    }

    @Override
    protected boolean containsAddress(Address address) {
        return this.instruction.contains(address);
    }

    @Override
    public String getTooltip(MouseEvent e) {
        return null;
    }

    @Override
    public int compare(DegVertex o1, DegVertex o2) {
        return o1.getAddress().compareTo((Object)o2.getAddress());
    }
}

