/*
 * Decompiled with CFR 0.152.
 */
package datagraph.data.graph;

import datagraph.DataGraphProvider;
import datagraph.DegSharedConfig;
import datagraph.data.graph.CodeDegVertex;
import datagraph.data.graph.DataDegVertex;
import datagraph.data.graph.DataExplorationGraph;
import datagraph.data.graph.DegEdge;
import datagraph.data.graph.DegGraphView;
import datagraph.data.graph.DegLayoutProvider;
import datagraph.data.graph.DegVertex;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.GraphMousePlugin;
import ghidra.app.util.XReferenceUtils;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.graph.GEdge;
import ghidra.graph.VisualGraph;
import ghidra.graph.job.GraphJob;
import ghidra.graph.job.RelayoutAndCenterVertexGraphJob;
import ghidra.graph.job.RelayoutAndEnsureVisible;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualGraphView;
import ghidra.graph.viewer.VisualGraphViewUpdater;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.event.mouse.VertexMouseInfo;
import ghidra.graph.viewer.event.mouse.VisualGraphPluggableGraphMouse;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.ProgramEvent;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;

public class DegController
implements DomainObjectListener {
    private static final int MAX_REFS = 50;
    private DegGraphView view;
    private DataExplorationGraph graph;
    private DegLayoutProvider layoutProvider = new DegLayoutProvider();
    private Program program;
    private boolean navigateOut = true;
    private boolean navigateIn = false;
    private boolean compactFormat = true;
    private DataGraphProvider provider;
    private DegSharedConfig sharedConfig;

    public DegController(DataGraphProvider provider, Data data, DegSharedConfig sharedConfig) {
        this.provider = provider;
        this.sharedConfig = sharedConfig;
        this.program = data.getProgram();
        this.view = new DegGraphView();
        DataDegVertex root = new DataDegVertex(this, data, null, true);
        this.graph = new DataExplorationGraph(root);
        this.graph.setLayout(this.getLayout());
        this.view.setGraph((VisualGraph)this.graph);
        this.installMouseListeners();
        this.program.addListener((DomainObjectListener)this);
        this.setFocusedVertex(root);
    }

    public void navigateOut(Address address, int[] componentPath) {
        if (this.navigateOut) {
            AddressFieldLocation location = new AddressFieldLocation(this.program, address, componentPath, address.toString(), 0);
            this.provider.navigateOut((ProgramLocation)location);
        }
    }

    public void dispose() {
        this.program.removeListener((DomainObjectListener)this);
    }

    public void repaint() {
        this.view.repaint();
    }

    public DegLayoutProvider getLayoutProvider() {
        return (DegLayoutProvider)this.view.getLayoutProvider();
    }

    public Component getComponent() {
        return this.view.getViewComponent();
    }

    public void relayoutGraph() {
        VisualGraphViewUpdater viewUpdater = this.view.getViewUpdater();
        viewUpdater.relayoutGraph();
    }

    public void centerVertex(DegVertex vertex) {
        VisualGraphViewUpdater viewUpdater = this.view.getViewUpdater();
        viewUpdater.moveVertexToCenterWithAnimation((VisualVertex)vertex);
    }

    public void centerPoint(Point point) {
        VisualGraphViewUpdater viewUpdater = this.view.getViewUpdater();
        viewUpdater.moveViewerLocationWithoutAnimation(point);
    }

    public void deleteVertices(Set<DegVertex> selectedVertices) {
        HashSet<DegVertex> toRemove = new HashSet<DegVertex>();
        for (DegVertex dgVertex : selectedVertices) {
            if (dgVertex.isRoot()) continue;
            if (!toRemove.contains(dgVertex)) {
                toRemove.addAll(this.graph.getDescendants(dgVertex));
            }
            toRemove.add(dgVertex);
        }
        this.graph.removeVertices(toRemove);
        this.repaint();
    }

    public void addOutGoingReferences(DataDegVertex source, Data subData) {
        ArrayList<DegVertex> addedVertices = new ArrayList<DegVertex>();
        this.doAddOutGoingReferences(source, subData, addedVertices);
        if (!addedVertices.isEmpty()) {
            this.relayoutGraphAndEnsureVisible(source, (DegVertex)addedVertices.getLast());
        }
    }

    public void showAllIncommingReferences(DataDegVertex sourceVertex) {
        CodeUnit target = sourceVertex.getCodeUnit();
        Listing listing = this.program.getListing();
        List refs = XReferenceUtils.getXReferences((CodeUnit)target, (int)51);
        if (refs.size() < 50) {
            int offcutMax = 51 - refs.size();
            List offcuts = XReferenceUtils.getOffcutXReferences((CodeUnit)target, (int)offcutMax);
            refs.addAll(offcuts);
        }
        if (refs.size() > 50) {
            Msg.showWarn((Object)this, null, (String)"Too Many References", (Object)"Only showing the first 50 number of references");
            refs = refs.subList(0, 50);
        }
        if (refs.isEmpty()) {
            Msg.showInfo((Object)this, null, (String)"No References Found", (Object)"There were no references or offcut references found to this data.");
            return;
        }
        this.doAddIncomingReferences(sourceVertex, listing, refs);
    }

    public void showAllOutgoingReferences(DataDegVertex sourceVertex) {
        Data data = sourceVertex.getData();
        int edgeCount = this.graph.getEdgeCount();
        ArrayList<DegVertex> addedVertices = new ArrayList<DegVertex>();
        if (!this.showAllOutgoingReferencesRecursively(sourceVertex, data, addedVertices)) {
            Msg.showWarn((Object)this, null, (String)"Too Many References", (Object)"Only added the first 50 references");
        }
        if (!addedVertices.isEmpty()) {
            this.relayoutGraphAndEnsureVisible(sourceVertex, (DegVertex)addedVertices.getLast());
        } else if (this.graph.getEdgeCount() != edgeCount) {
            this.relayoutGraph();
        } else {
            Msg.showInfo((Object)data, null, (String)"No New Outgoing References Found", (Object)"There were no additional references found to this data.");
        }
    }

    public void orientAround(DegVertex newRoot) {
        this.graph.setRoot(newRoot);
        this.relayoutGraphAndCenter(newRoot);
        this.provider.updateSubTitle();
    }

    public VisualGraphView<DegVertex, DegEdge, DataExplorationGraph> getView() {
        return this.view;
    }

    public DegVertex getFocusedVertex() {
        return (DegVertex)this.view.getFocusedVertex();
    }

    public Program getProgram() {
        return this.program;
    }

    public void setNavigateOut(boolean b) {
        this.navigateOut = b;
        this.sharedConfig.setNavigateOut(b);
    }

    public void setNavigateIn(boolean b) {
        this.navigateIn = b;
        this.sharedConfig.setNavigateIn(b);
    }

    public void setCompactFormat(boolean b) {
        this.compactFormat = b;
        this.graph.getVertices().forEach(v -> {
            if (v instanceof DataDegVertex) {
                DataDegVertex dataVertex = (DataDegVertex)v;
                dataVertex.setCompactFormat(b);
            }
        });
        this.relayoutGraph();
        this.sharedConfig.setCompactFormat(b);
    }

    public void setPopupsVisible(boolean b) {
        this.view.setPopupsVisible(b);
        this.sharedConfig.setShowPopups(b);
    }

    public boolean isCompactFormat() {
        return this.compactFormat;
    }

    public void resetAndRelayoutGraph() {
        this.graph.getVertices().forEach(v -> v.clearUserChangedLocation());
        this.relayoutGraph();
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.contains((EventType)DomainObjectEvent.RESTORED)) {
            this.refreshGraph(true);
            return;
        }
        boolean dataTypesChanged = ev.contains(new EventType[]{ProgramEvent.DATA_TYPE_CHANGED, ProgramEvent.DATA_TYPE_REMOVED});
        boolean refreshNeeded = ev.contains((EventType)ProgramEvent.CODE_REMOVED) | dataTypesChanged;
        if (refreshNeeded) {
            this.refreshGraph(dataTypesChanged);
        }
        this.repaint();
    }

    public Set<DegVertex> getOutgoingVertices(DataDegVertex vertex) {
        Collection outEdges = this.graph.getOutEdges(vertex);
        return outEdges.stream().map(e -> (DegVertex)e.getEnd()).collect(Collectors.toSet());
    }

    public Set<DegVertex> getIncomingVertices(DataDegVertex vertex) {
        Collection inEdges = this.graph.getOutEdges(vertex);
        return inEdges.stream().map(e -> (DegVertex)e.getStart()).collect(Collectors.toSet());
    }

    public DataExplorationGraph getGraph() {
        return this.graph;
    }

    public GraphViewer<DegVertex, DegEdge> getPrimaryViewer() {
        return this.view.getPrimaryGraphViewer();
    }

    public void setLocation(ProgramLocation location) {
        if (!this.navigateIn) {
            return;
        }
        if (this.program != location.getProgram()) {
            return;
        }
        Address address = location.getAddress();
        Collection vertices = this.graph.getVertices();
        for (DegVertex dgVertex : vertices) {
            if (!dgVertex.containsAddress(address)) continue;
            this.navigateTo(dgVertex);
            break;
        }
    }

    private void doAddIncomingReferences(DataDegVertex sourceVertex, Listing listing, List<Reference> xReferences) {
        boolean vertexOrEdgeAdded = false;
        for (Reference reference : xReferences) {
            vertexOrEdgeAdded |= this.doAddIncomingVertices(sourceVertex, listing, reference);
        }
        if (!vertexOrEdgeAdded) {
            Msg.showInfo((Object)this, null, (String)"No New References Found", (Object)"There were no additional references or offcut references found to this data.");
        }
    }

    private boolean doAddIncomingVertices(DataDegVertex sourceVertex, Listing listing, Reference reference) {
        Address toAddress = reference.getToAddress();
        Address fromAddress = reference.getFromAddress();
        CodeUnit cu = listing.getCodeUnitContaining(fromAddress);
        DegVertex v = this.createVertex(cu, sourceVertex);
        if (!this.graph.containsVertex(v)) {
            this.graph.getLayout().setLocation((Object)v, sourceVertex.getLocation());
            this.graph.addVertex((VisualVertex)v);
            DegEdge newEdge = new DegEdge(v, sourceVertex);
            this.addIncomingEdge(fromAddress, toAddress, cu, newEdge);
            return true;
        }
        DegEdge newEdge = new DegEdge(v = this.resolve(v), sourceVertex);
        if (!this.graph.containsEdge((Object)newEdge)) {
            this.addIncomingEdge(fromAddress, toAddress, cu, newEdge);
            return true;
        }
        return false;
    }

    private void addIncomingEdge(Address fromAddress, Address toAddress, CodeUnit cu, DegEdge newEdge) {
        this.graph.addEdge((GEdge)newEdge);
        DegVertex newVertex = (DegVertex)newEdge.getStart();
        DataDegVertex sourceVertex = (DataDegVertex)newEdge.getEnd();
        if (newVertex instanceof DataDegVertex) {
            DataDegVertex dv = (DataDegVertex)newVertex;
            dv.addOutgoingEdgeAnchor(sourceVertex, this.findComponentPath((Data)cu, fromAddress));
        }
        sourceVertex.addIncomingEdgeAnchor(newVertex, toAddress);
        this.relayoutGraphAndEnsureVisible(sourceVertex, newVertex);
    }

    private DegVertex addDestinationVertex(DataDegVertex sourceVertex, Address a, Data sourceData) {
        CodeUnit cu = this.program.getListing().getCodeUnitContaining(a);
        if (cu == null) {
            return null;
        }
        DegVertex v = this.createVertex(cu, sourceVertex);
        if (!this.graph.containsVertex(v)) {
            this.graph.getLayout().setLocation((Object)v, sourceVertex.getLocation());
            this.graph.addVertex((VisualVertex)v);
            this.graph.addEdge((GEdge)new DegEdge(sourceVertex, v));
            sourceVertex.addOutgoingEdgeAnchor(v, sourceData.getComponentPath());
            if (v instanceof DataDegVertex) {
                DataDegVertex dataVertex = (DataDegVertex)v;
                dataVertex.addIncomingEdgeAnchor(sourceVertex, a);
            }
            return v;
        }
        if (!this.graph.containsEdge((Object)new DegEdge(sourceVertex, v))) {
            v = this.resolve(v);
            this.graph.addEdge((GEdge)new DegEdge(sourceVertex, v));
            sourceVertex.addOutgoingEdgeAnchor(v, sourceData.getComponentPath());
            if (v instanceof DataDegVertex) {
                DataDegVertex dataVertex = (DataDegVertex)v;
                dataVertex.addIncomingEdgeAnchor(sourceVertex, a);
            }
        } else {
            sourceVertex.addOutgoingEdgeAnchor(v, sourceData.getComponentPath());
        }
        return null;
    }

    private Set<Address> getOutgoingReferenceAddresses(Data data) {
        Reference[] referencesFrom;
        HashSet<Address> destinations = new HashSet<Address>();
        ReferenceManager referenceManager = this.program.getReferenceManager();
        Address fromAddress = data.getAddress();
        for (Reference reference : referencesFrom = referenceManager.getReferencesFrom(fromAddress)) {
            destinations.add(reference.getToAddress());
        }
        Object value = data.getValue();
        if (value instanceof Address) {
            Address address = (Address)value;
            destinations.add(address);
        }
        return destinations;
    }

    private DegVertex createVertex(CodeUnit cu, DegVertex source) {
        if (cu instanceof Data) {
            Data data = (Data)cu;
            return new DataDegVertex(this, data, source, this.compactFormat);
        }
        return new CodeDegVertex(this, (Instruction)cu, source);
    }

    void relayoutGraphAndEnsureVisible(DegVertex primary, DegVertex secondary) {
        if (primary == null || secondary == null) {
            this.relayoutGraph();
            return;
        }
        VisualGraphViewUpdater viewUpdater = this.view.getViewUpdater();
        GraphViewer viewer = this.view.getPrimaryGraphViewer();
        RelayoutAndEnsureVisible job = new RelayoutAndEnsureVisible(viewer, (VisualVertex)primary, (VisualVertex)secondary, viewUpdater.isAnimationEnabled());
        viewUpdater.scheduleViewChangeJob((GraphJob)job);
    }

    void relayoutGraphAndCenter(DegVertex vertex) {
        VisualGraphViewUpdater viewUpdater = this.view.getViewUpdater();
        GraphViewer viewer = this.view.getPrimaryGraphViewer();
        RelayoutAndCenterVertexGraphJob job = new RelayoutAndCenterVertexGraphJob(viewer, (VisualVertex)vertex, viewUpdater.isAnimationEnabled());
        viewUpdater.scheduleViewChangeJob((GraphJob)job);
    }

    private DegVertex resolve(DegVertex searchVertex) {
        for (DegVertex v : this.graph.getVertices()) {
            if (!v.equals(searchVertex)) continue;
            return v;
        }
        return null;
    }

    private boolean showAllOutgoingReferencesRecursively(DataDegVertex sourceVertex, Data data, List<DegVertex> added) {
        if (data.getNumComponents() == 0) {
            this.doAddOutGoingReferences(sourceVertex, data, added);
        }
        for (int i = 0; i < data.getNumComponents(); ++i) {
            if (added.size() >= 50) {
                return false;
            }
            Data subData = data.getComponent(i);
            if (this.showAllOutgoingReferencesRecursively(sourceVertex, subData, added)) continue;
            return false;
        }
        return true;
    }

    private void doAddOutGoingReferences(DataDegVertex source, Data data, List<DegVertex> added) {
        Set<Address> addresses = this.getOutgoingReferenceAddresses(data);
        for (Address address : addresses) {
            DegVertex newVertex = this.addDestinationVertex(source, address, data);
            if (newVertex == null) continue;
            added.add(newVertex);
        }
    }

    private int[] findComponentPath(Data data, Address fromAddress) {
        if (data == null) {
            return new int[0];
        }
        int offset = (int)fromAddress.subtract(data.getAddress());
        if (offset == 0) {
            return data.getComponentPath();
        }
        Data componentContaining = data.getComponentContaining(offset);
        return this.findComponentPath(componentContaining, fromAddress);
    }

    private void refreshGraph(boolean checkDataTypes) {
        HashSet<DegVertex> toDelete = new HashSet<DegVertex>();
        for (DegVertex dgVertex : this.graph.getVertices()) {
            DegVertex.DegVertexStatus status = dgVertex.refreshGraph(checkDataTypes);
            if (status == DegVertex.DegVertexStatus.MISSING) {
                toDelete.add(dgVertex);
                toDelete.addAll(this.graph.getDescendants(dgVertex));
                continue;
            }
            if (status != DegVertex.DegVertexStatus.CHANGED) continue;
            this.removeOutgoingEdges(toDelete, dgVertex);
        }
        this.graph.removeVertices(toDelete);
    }

    private void removeOutgoingEdges(Set<DegVertex> toDelete, DegVertex dgVertex) {
        Collection outEdges = this.graph.getOutEdges(dgVertex);
        for (DegEdge edge : outEdges) {
            DegVertex other = (DegVertex)edge.getEnd();
            if (other.getSourceVertex() == dgVertex) {
                toDelete.add(other);
                toDelete.addAll(this.graph.getDescendants(other));
                continue;
            }
            toDelete.add(dgVertex);
            toDelete.addAll(this.graph.getDescendants(dgVertex));
        }
    }

    public void selectAndCenterHomeVertex() {
        this.navigateTo((DegVertex)this.graph.getRoot());
    }

    private void navigateTo(DegVertex dgVertex) {
        this.setFocusedVertex(dgVertex);
        this.centerVertex(dgVertex);
    }

    private void installMouseListeners() {
        VisualGraphPluggableGraphMouse graphMouse = this.view.getPrimaryGraphViewer().getGraphMouse();
        graphMouse.prepend((GraphMousePlugin)new DataMousePlugin());
    }

    private VisualGraphLayout<DegVertex, DegEdge> getLayout() {
        try {
            return this.layoutProvider.getLayout(this.graph, TaskMonitor.DUMMY);
        }
        catch (CancelledException e) {
            return null;
        }
    }

    private void setFocusedVertex(DegVertex v) {
        this.view.getGraphComponent().setVertexFocused((VisualVertex)v);
    }

    private boolean isOnResizeCorner(VertexMouseInfo<DegVertex, DegEdge> vertexMouseInfo) {
        DegVertex vertex = (DegVertex)vertexMouseInfo.getVertex();
        Point2D p = vertexMouseInfo.getVertexRelativeClickPoint();
        Dimension vertexSize = vertex.getComponent().getSize();
        return p.getX() > (double)(vertexSize.width - 10) && p.getY() > (double)(vertexSize.height - 10);
    }

    private class DataMousePlugin
    extends AbstractGraphMousePlugin
    implements MouseWheelListener,
    MouseMotionListener,
    MouseListener {
        private VertexMouseInfo<DegVertex, DegEdge> dragStart;
        private Dimension startSize;
        private boolean isFiringWheelEvent;

        public DataMousePlugin() {
            super(0);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (this.isFiringWheelEvent) {
                return;
            }
            VertexMouseInfo<DegVertex, DegEdge> vertexMouseInfo = this.getTranslatedMouseInfo(e);
            if (vertexMouseInfo == null) {
                return;
            }
            if (vertexMouseInfo.isScaledPastInteractionThreshold()) {
                return;
            }
            if (e.getModifiersEx() != 0) {
                return;
            }
            try {
                this.isFiringWheelEvent = true;
                vertexMouseInfo.forwardEvent();
            }
            finally {
                this.isFiringWheelEvent = false;
            }
            DegController.this.repaint();
        }

        private VertexMouseInfo<DegVertex, DegEdge> getTranslatedMouseInfo(MouseEvent e) {
            GraphViewer viewer = DegController.this.view.getPrimaryGraphViewer();
            return GraphViewerUtils.convertMouseEventToVertexMouseEvent((GraphViewer)viewer, (MouseEvent)e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.dragStart == null) {
                return;
            }
            MouseEvent startEv = this.dragStart.getOriginalMouseEvent();
            int x = e.getX() - startEv.getX();
            int y = e.getY() - startEv.getY();
            DataDegVertex vertex = (DataDegVertex)this.dragStart.getVertex();
            int newWidth = Math.max(this.startSize.width + x, 50);
            int newHeight = Math.max(this.startSize.height + y, 50);
            vertex.setSizeByUser(new Dimension(newWidth, newHeight));
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            VertexMouseInfo<DegVertex, DegEdge> vertexMouseInfo = this.getTranslatedMouseInfo(e);
            if (vertexMouseInfo == null) {
                return;
            }
            if (vertexMouseInfo.isScaledPastInteractionThreshold()) {
                return;
            }
            JComponent c = (JComponent)vertexMouseInfo.getEventSource();
            if (DegController.this.isOnResizeCorner(vertexMouseInfo)) {
                c.setCursor(Cursor.getPredefinedCursor(5));
                e.consume();
            } else {
                c.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            VertexMouseInfo<DegVertex, DegEdge> vertexMouseInfo = this.getTranslatedMouseInfo(e);
            if (vertexMouseInfo == null) {
                return;
            }
            if (vertexMouseInfo.isScaledPastInteractionThreshold()) {
                return;
            }
            DegVertex vertex = (DegVertex)vertexMouseInfo.getVertex();
            if (vertex instanceof DataDegVertex) {
                DataDegVertex dataVertex = (DataDegVertex)vertex;
                if (DegController.this.isOnResizeCorner(vertexMouseInfo)) {
                    this.dragStart = vertexMouseInfo;
                    this.startSize = dataVertex.getSize();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.dragStart != null) {
                DegController.this.relayoutGraph();
                this.dragStart = null;
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

