/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.repulsion;

import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jungrapht.visualization.layout.algorithms.repulsion.StandardRepulsion;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;

public class StandardFA2Repulsion<V, R extends StandardFA2Repulsion<V, R, B>, B extends Builder<V, R, B>>
implements StandardRepulsion<V, R, B> {
    protected Map<V, Point> frVertexData;
    protected Function<V, Point> initializer = v -> Point.ORIGIN;
    protected LayoutModel<V> layoutModel;
    protected Set<V> vertexSet;
    protected Random random = new Random();
    protected double kr = 100.0;
    protected Function<V, Double> nodeSizes;
    protected Map<V, Double> nodeMasses;
    protected static final double epsilon = 1.0E-16;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static Builder standardBuilder() {
        return StandardFA2Repulsion.builder();
    }

    protected StandardFA2Repulsion(Builder<V, R, B> builder) {
        this.frVertexData = builder.frVertexData;
        this.initializer = builder.initializer;
        this.layoutModel = builder.layoutModel;
        this.vertexSet = this.layoutModel.getGraph().vertexSet();
        this.random = builder.random;
        this.kr = builder.kr;
        this.nodeSizes = builder.nodeSizes == null ? v -> 1.0 : builder.nodeSizes;
        this.nodeMasses = builder.nodeMasses == null ? this.layoutModel.getGraph().vertexSet().stream().collect(Collectors.toMap(v -> v, v -> (double)this.layoutModel.getGraph().degreeOf(v) + 1.0)) : builder.nodeMasses;
    }

    @Override
    public void step() {
    }

    public Random getRandom() {
        return this.random;
    }

    @Override
    public void calculateRepulsion() {
        for (V vertex1 : this.vertexSet) {
            Point fvd1 = Point.ORIGIN;
            Point p1 = (Point)this.layoutModel.apply(vertex1);
            double vertexOneMass = this.nodeMasses.get(vertex1);
            double vertexOneSize = this.nodeSizes.apply(vertex1);
            try {
                for (V vertex2 : this.vertexSet) {
                    double force;
                    if (vertex1 == vertex2) continue;
                    Point p2 = (Point)this.layoutModel.apply(vertex2);
                    if (p1 == null || p2 == null) continue;
                    double dx = p1.x - p2.x;
                    double dy = p1.y - p2.y;
                    double vertex2Mass = this.nodeMasses.get(vertex2);
                    double dist = Math.max(1.0E-16, Math.sqrt(dx * dx + dy * dy));
                    if (Double.isNaN(force = (dist -= vertexOneSize + this.nodeSizes.apply(vertex2)) > 0.0 ? this.kr * vertexOneMass * vertex2Mass / dist / dist : (dist < 0.0 ? this.kr * vertexOneMass * vertex2Mass / dist : 0.0))) {
                        throw new RuntimeException("Unexpected mathematical result in FRLayout:calcPositions [repulsion]");
                    }
                    fvd1 = fvd1.add(dx * force, dy * force);
                }
                this.frVertexData.put((Point)vertex1, fvd1);
            }
            catch (ConcurrentModificationException cme) {
                this.calculateRepulsion();
            }
        }
    }

    public static class Builder<V, R extends StandardFA2Repulsion<V, R, B>, B extends Builder<V, R, B>>
    implements StandardRepulsion.Builder<V, R, B> {
        protected Map<V, Point> frVertexData;
        protected Function<V, Point> initializer = v -> Point.ORIGIN;
        protected LayoutModel<V> layoutModel;
        protected Random random = new Random();
        protected double kr = 1.0;
        protected Function<V, Double> nodeSizes = null;
        protected Map<V, Double> nodeMasses = null;

        public B nodeData(Map<V, Point> frVertexData) {
            this.frVertexData = frVertexData;
            return (B)this;
        }

        public B initializer(Function<V, Point> initializer) {
            this.initializer = initializer;
            return (B)this;
        }

        @Override
        public B layoutModel(LayoutModel<V> layoutModel) {
            this.layoutModel = layoutModel;
            return (B)this;
        }

        @Override
        public B random(Random random) {
            this.random = random;
            return (B)this;
        }

        public B nodeSizes(Function<V, Double> nodeSizes) {
            this.nodeSizes = nodeSizes;
            return (B)this;
        }

        public B repulsionK(double kr) {
            this.kr = kr;
            return (B)this;
        }

        public B nodeMasses(Map<V, Double> nodeMasses) {
            this.nodeMasses = nodeMasses;
            return (B)this;
        }

        @Override
        public R build() {
            return (R)new StandardFA2Repulsion(this);
        }
    }
}

