/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.sys;

import ghidra.pcode.emu.sys.EmuFileContents;
import org.apache.commons.lang3.tuple.Pair;

public class PairedEmuFileContents<L, R>
implements EmuFileContents<Pair<L, R>> {
    protected final EmuFileContents<L> left;
    protected final EmuFileContents<R> right;

    public PairedEmuFileContents(EmuFileContents<L> left, EmuFileContents<R> right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public long read(long offset, Pair<L, R> buf, long fileSize) {
        long result = this.left.read(offset, buf.getLeft(), fileSize);
        this.right.read(offset, buf.getRight(), fileSize);
        return result;
    }

    @Override
    public long write(long offset, Pair<L, R> buf, long curSize) {
        long result = this.left.write(offset, buf.getLeft(), curSize);
        this.right.write(offset, buf.getRight(), curSize);
        return result;
    }

    @Override
    public void truncate() {
        this.left.truncate();
        this.right.truncate();
    }
}

