/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;

public class DeleteFunctionCmd
implements Command<Program> {
    private Address entry;
    private boolean ignoreMissingFunction;

    public DeleteFunctionCmd(Address entry) {
        this(entry, true);
    }

    public DeleteFunctionCmd(Address entry, boolean ignoreMissingFunction) {
        this.entry = entry;
        this.ignoreMissingFunction = ignoreMissingFunction;
    }

    public String getName() {
        return "Delete Function";
    }

    public boolean applyTo(Program program) {
        Listing listing = program.getListing();
        Function func = listing.getFunctionAt(this.entry);
        if (func == null) {
            return this.ignoreMissingFunction;
        }
        if (!this.entry.isExternalAddress()) {
            func.promoteLocalUserLabelsToGlobal();
        }
        listing.removeFunction(this.entry);
        return true;
    }

    public String getStatusMsg() {
        return "";
    }
}

