/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.refs;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;

public class RemoveExternalRefCmd
implements Command<Program> {
    private Address fromAddr;
    private int opIndex;

    public RemoveExternalRefCmd(Address fromAddr, int opIndex) {
        this.fromAddr = fromAddr;
        this.opIndex = opIndex;
    }

    public boolean applyTo(Program program) {
        Reference[] refs;
        ReferenceManager refMgr = program.getReferenceManager();
        for (Reference ref : refs = refMgr.getReferencesFrom(this.fromAddr, this.opIndex)) {
            if (!ref.isExternalReference()) continue;
            refMgr.delete(ref);
        }
        return true;
    }

    public String getStatusMsg() {
        return null;
    }

    public String getName() {
        return "Remove External Reference";
    }
}

