/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.reloc;

import docking.ComponentProvider;
import docking.action.DockingActionIf;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.plugin.core.reloc.RelocationProvider;
import ghidra.app.services.GoToService;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramEvent;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.table.actions.MakeProgramSelectionAction;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Displays relocation information", description="This plugin provides a component for displaying the reloction table. The table can be used to navigate in the code browser.", servicesRequired={GoToService.class}, eventsProduced={ProgramLocationPluginEvent.class}, eventsConsumed={ProgramActivatedPluginEvent.class})
public class RelocationTablePlugin
extends Plugin
implements DomainObjectListener {
    private Program currentProgram;
    private RelocationProvider provider;

    public RelocationTablePlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        this.provider = new RelocationProvider(this);
        this.createActions();
    }

    private void createActions() {
        MakeProgramSelectionAction selectAction = new MakeProgramSelectionAction(this, this.provider.getTable());
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)selectAction);
        SelectionNavigationAction navigationAction = new SelectionNavigationAction(this, this.provider.getTable());
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)navigationAction);
    }

    public void dispose() {
        super.dispose();
        this.provider.dispose();
        this.currentProgram = null;
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent ev = (ProgramActivatedPluginEvent)event;
            Program oldProg = this.currentProgram;
            Program newProg = ev.getActiveProgram();
            if (oldProg != null) {
                this.programClosed();
            }
            if (newProg != null) {
                this.programOpened(newProg);
            }
        }
    }

    private void programOpened(Program p) {
        p.addListener((DomainObjectListener)this);
        this.currentProgram = p;
        this.provider.setProgram(p);
    }

    private void programClosed() {
        this.currentProgram.removeListener((DomainObjectListener)this);
        this.currentProgram = null;
        this.provider.setProgram(null);
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.contains(new EventType[]{ProgramEvent.IMAGE_BASE_CHANGED, ProgramEvent.RELOCATION_ADDED, DomainObjectEvent.RESTORED})) {
            this.provider.setProgram(this.currentProgram);
        }
    }
}

