/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.match;

import ghidra.app.plugin.match.SubroutineMatch;
import ghidra.program.model.address.Address;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SymbolTable;
import java.util.ArrayList;

public class SubroutineMatchSet
extends ArrayList<SubroutineMatch> {
    public final Program aProgram;
    public final Program bProgram;
    private final SymbolTable aSymbolTable;
    private final SymbolTable bSymbolTable;
    private final CodeBlockModel aModel;
    private final CodeBlockModel bModel;

    public SubroutineMatchSet(Program aProgram, CodeBlockModel aModel, Program bProgram, CodeBlockModel bModel) {
        this.aProgram = aProgram;
        this.bProgram = bProgram;
        this.aSymbolTable = aProgram.getSymbolTable();
        this.bSymbolTable = bProgram.getSymbolTable();
        this.aModel = aModel;
        this.bModel = bModel;
    }

    public SubroutineMatch[] getMatches() {
        SubroutineMatch[] theMatches = this.toArray(new SubroutineMatch[0]);
        return theMatches;
    }

    public int getLength(Address addr, CodeBlockModel model) {
        int length = 0;
        try {
            CodeBlock block = model.getCodeBlockAt(addr, null);
            length = (int)block.getNumAddresses();
        }
        catch (Exception e) {
            return 0;
        }
        return length;
    }

    public int getLength(Address addr) {
        return this.getLength(addr, this.aModel);
    }

    CodeBlockModel getAModel() {
        return this.aModel;
    }

    CodeBlockModel getBModel() {
        return this.bModel;
    }

    SymbolTable getATable() {
        return this.aSymbolTable;
    }

    SymbolTable getBTable() {
        return this.bSymbolTable;
    }
}

