/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.external;

import ghidra.app.util.bin.format.dwarf.external.ExternalDebugInfo;
import ghidra.app.util.bin.format.dwarf.external.LocalDirectorySearchLocation;
import ghidra.app.util.bin.format.dwarf.external.SearchLocation;
import ghidra.app.util.bin.format.dwarf.external.SearchLocationCreatorContext;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;

public class SameDirSearchLocation
implements SearchLocation {
    private final File progDir;

    public static boolean isSameDirSearchLocation(String locString) {
        return locString.equals(".");
    }

    public static SameDirSearchLocation create(String locString, SearchLocationCreatorContext context) {
        File exeLocation = new File(FilenameUtils.getFullPath((String)context.getProgram().getExecutablePath()));
        return new SameDirSearchLocation(exeLocation);
    }

    public SameDirSearchLocation(File progDir) {
        this.progDir = progDir;
    }

    @Override
    public String getName() {
        return ".";
    }

    @Override
    public String getDescriptiveName() {
        return this.progDir.getPath() + " (Program's Import Location)";
    }

    @Override
    public FSRL findDebugFile(ExternalDebugInfo debugInfo, TaskMonitor monitor) throws IOException, CancelledException {
        if (!debugInfo.hasFilename()) {
            return null;
        }
        File file = new File(this.progDir, debugInfo.getFilename());
        if (!file.isFile()) {
            return null;
        }
        int fileCRC = LocalDirectorySearchLocation.calcCRC(file);
        if (fileCRC != debugInfo.getCrc()) {
            Msg.info((Object)this, (Object)("DWARF external debug file found with mismatching crc, ignored: " + String.valueOf(file) + ", (" + Integer.toHexString(fileCRC) + ")"));
            return null;
        }
        return FileSystemService.getInstance().getLocalFSRL(file);
    }
}

