/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.funcfixup;

import ghidra.app.util.bin.format.dwarf.DWARFFunction;
import ghidra.app.util.bin.format.dwarf.DWARFVariable;
import ghidra.app.util.bin.format.dwarf.funcfixup.DWARFFunctionFixup;
import ghidra.util.classfinder.ExtensionPointProperties;

@ExtensionPointProperties(priority=2000)
public class OutputParamCheckDWARFFunctionFixup
implements DWARFFunctionFixup {
    @Override
    public void fixupDWARFFunction(DWARFFunction dfunc) {
        for (DWARFVariable dvar : dfunc.params) {
            if (!dvar.isOutputParameter || !dvar.isMissingStorage()) continue;
            String paramName = dvar.name.getName();
            dfunc.getProgram().logWarningAt(dfunc.address, dfunc.name.getName(), "Unsupported output parameter %s".formatted(paramName));
        }
    }
}

