/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import utilities.util.FileUtilities;

public class JsonPatch {
    private List<PatchSection> sections;

    public static JsonPatch read(String patchString) throws IOException {
        return JsonPatch.read(FileUtilities.getLines((BufferedReader)new BufferedReader(new StringReader(patchString))).listIterator());
    }

    public static JsonPatch read(File patchFile) throws IOException {
        List lines = FileUtilities.getLines((File)patchFile);
        return JsonPatch.read(lines.listIterator());
    }

    public static JsonPatch read(ListIterator<String> lineIterator) throws IOException {
        PatchSection section;
        ArrayList<PatchSection> sections = new ArrayList<PatchSection>();
        while (lineIterator.hasNext() && (section = JsonPatch.readPatchSection(lineIterator)) != null) {
            sections.add(section);
        }
        return new JsonPatch(sections);
    }

    public static JsonPatch read(JsonArray patchSectionElements) throws IOException {
        ArrayList<PatchSection> sections = new ArrayList<PatchSection>();
        for (int i = 0; i < patchSectionElements.size(); ++i) {
            sections.add(JsonPatch.readPatchSection(patchSectionElements.get(i).getAsJsonObject()));
        }
        return new JsonPatch(sections);
    }

    public JsonPatch(List<PatchSection> sections) {
        this.sections = sections;
    }

    public int getSectionCount() {
        return this.sections.size();
    }

    public List<PatchSection> getSections() {
        return this.sections;
    }

    public JsonArray toJson() {
        JsonArray result = new JsonArray();
        this.sections.forEach(section -> result.add((JsonElement)section.toJson()));
        return result;
    }

    private static PatchSection readPatchSection(JsonObject patchSectionElem) throws IOException {
        JsonArray arr;
        JsonArray elements;
        JsonArray arr2;
        JsonElement jsonElement = patchSectionElem.get("path");
        JsonArray path = jsonElement instanceof JsonArray ? (arr2 = (JsonArray)jsonElement) : null;
        JsonElement jsonElement2 = patchSectionElem.get("elements");
        JsonArray jsonArray = elements = jsonElement2 instanceof JsonArray ? (arr = (JsonArray)jsonElement2) : null;
        if (path == null || elements == null) {
            throw new IOException();
        }
        ArrayList<PatchLine> lines = new ArrayList<PatchLine>();
        for (int i = 0; i < elements.size(); ++i) {
            lines.add(JsonPatch.lineFromJson(elements.get(i).getAsJsonObject()));
        }
        return new PatchSection(path, lines);
    }

    private static PatchLine lineFromJson(JsonObject jsonObj) throws IOException {
        PatchOp patchOp;
        JsonElement jsonElement = jsonObj.get("op");
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive prim = (JsonPrimitive)jsonElement;
            patchOp = PatchOp.fromChar(prim.getAsCharacter());
        } else {
            patchOp = null;
        }
        PatchOp op = patchOp;
        JsonElement value = jsonObj.get("value");
        if (op == null || op == PatchOp.ADD && value == null) {
            throw new IOException("bad patch element: " + String.valueOf(jsonObj));
        }
        return new PatchLine(op, value);
    }

    private static PatchSection readPatchSection(ListIterator<String> lineIt) throws IOException {
        String line;
        String string = line = lineIt.hasNext() ? lineIt.next() : null;
        if (line == null) {
            return null;
        }
        if (!line.startsWith("@ ")) {
            throw new IOException("bad start of patch section: " + line);
        }
        JsonElement pathElem = JsonParser.parseString((String)line.substring(2));
        ArrayList<PatchLine> patchLines = new ArrayList<PatchLine>();
        while (lineIt.hasNext()) {
            line = lineIt.next();
            if (line.length() < 3) continue;
            char opChar = line.charAt(0);
            if (opChar == '+' || opChar == '-') {
                PatchOp patchOp = PatchOp.fromChar(opChar);
                JsonElement val = patchOp == PatchOp.ADD ? JsonParser.parseString((String)line.substring(2)) : null;
                patchLines.add(new PatchLine(patchOp, val));
                continue;
            }
            if (opChar != '@') continue;
            lineIt.previous();
            break;
        }
        PatchSection section = new PatchSection(pathElem.getAsJsonArray(), patchLines);
        return section;
    }

    public record PatchSection(JsonArray path, List<PatchLine> lines) {
        public JsonObject toJson() {
            JsonObject result = new JsonObject();
            result.add("path", (JsonElement)this.path);
            JsonArray elements = new JsonArray();
            this.lines.forEach(line -> elements.add((JsonElement)line.toJson()));
            result.add("elements", (JsonElement)elements);
            return result;
        }
    }

    public record PatchLine(PatchOp operation, JsonElement value) {
        public JsonObject toJson() {
            JsonObject result = new JsonObject();
            result.addProperty("op", this.operation.getOpChar());
            if (this.value != null) {
                result.add("value", this.value);
            }
            return result;
        }
    }

    public static enum PatchOp {
        ADD,
        REMOVE,
        CONTEXT;


        public static PatchOp fromChar(char ch) {
            return switch (ch) {
                case '+' -> ADD;
                case '-' -> REMOVE;
                default -> null;
            };
        }

        public String getOpChar() {
            return switch (this.ordinal()) {
                case 0 -> "+";
                case 1 -> "-";
                default -> "??";
            };
        }
    }
}

