/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfo1;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfo2;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfo3;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfo4;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfo5;
import ghidra.app.util.bin.format.macho.dyld.DyldFixup;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

public abstract class DyldCacheSlideInfoCommon
implements StructConverter {
    public static final int DATA_PAGE_MAP_ENTRY = 1;
    public static final int BYTES_PER_CHAIN_OFFSET = 4;
    public static final int CHAIN_OFFSET_MASK = 16383;
    protected int version;
    protected long slideInfoOffset;
    protected DyldCacheMappingInfo mappingInfo;

    public static DyldCacheSlideInfoCommon parseSlideInfo(BinaryReader reader, long slideInfoOffset, DyldCacheMappingInfo mappingInfo, MessageLog log, TaskMonitor monitor) {
        if (slideInfoOffset == 0L) {
            return null;
        }
        monitor.setMessage("Parsing DYLD slide info...");
        monitor.initialize(1L);
        Object errorMessage = "Failed to parse dyld_cache_slide_info";
        try {
            reader.setPointerIndex(slideInfoOffset);
            int version = reader.readInt(reader.getPointerIndex());
            errorMessage = (String)errorMessage + version;
            DyldCacheSlideInfoCommon returnedSlideInfo = switch (version) {
                case 1 -> new DyldCacheSlideInfo1(reader, mappingInfo);
                case 2 -> new DyldCacheSlideInfo2(reader, mappingInfo);
                case 3 -> new DyldCacheSlideInfo3(reader, mappingInfo);
                case 4 -> new DyldCacheSlideInfo4(reader, mappingInfo);
                case 5 -> new DyldCacheSlideInfo5(reader, mappingInfo);
                default -> throw new IOException();
            };
            monitor.incrementProgress(1L);
            returnedSlideInfo.slideInfoOffset = slideInfoOffset;
            return returnedSlideInfo;
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheSlideInfoCommon.class.getSimpleName(), (String)errorMessage);
            return null;
        }
    }

    public DyldCacheSlideInfoCommon(BinaryReader reader, DyldCacheMappingInfo mappingInfo) throws IOException {
        this.mappingInfo = mappingInfo;
        this.version = reader.readNextInt();
    }

    public int getVersion() {
        return this.version;
    }

    public long getSlideInfoOffset() {
        return this.slideInfoOffset;
    }

    public DyldCacheMappingInfo getMappingInfo() {
        return this.mappingInfo;
    }

    public abstract List<DyldFixup> getSlideFixups(BinaryReader var1, int var2, MessageLog var3, TaskMonitor var4) throws IOException, CancelledException;

    public void fixupSlidePointers(Program program, boolean markup, boolean addRelocations, MessageLog log, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        Memory memory = program.getMemory();
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        Address dataPageAddr = space.getAddress(this.mappingInfo.getAddress());
        try (MemoryByteProvider provider = new MemoryByteProvider(memory, dataPageAddr);){
            Address addr;
            BinaryReader reader = new BinaryReader(provider, !memory.isBigEndian());
            List<DyldFixup> fixups = this.getSlideFixups(reader, program.getDefaultPointerSize(), log, monitor);
            monitor.initialize((long)fixups.size(), "Fixing DYLD Cache slide pointers...");
            for (DyldFixup fixup : fixups) {
                monitor.increment();
                addr = dataPageAddr.add(fixup.offset());
                if (fixup.size() == 8) {
                    memory.setLong(addr, fixup.value().longValue());
                    continue;
                }
                memory.setInt(addr, fixup.value().intValue());
            }
            if (markup) {
                monitor.initialize((long)fixups.size(), "Marking up DYLD Cache slide pointers...");
                for (DyldFixup fixup : fixups) {
                    monitor.increment();
                    addr = dataPageAddr.add(fixup.offset());
                    if (addRelocations) {
                        program.getRelocationTable().add(addr, Relocation.Status.APPLIED, this.version, new long[]{fixup.value()}, fixup.size(), null);
                    }
                    try {
                        program.getListing().createData(addr, POINTER);
                    }
                    catch (CodeUnitInsertionException codeUnitInsertionException) {}
                }
            }
        }
        catch (IOException e) {
            throw new MemoryAccessException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_slide_info", 0);
        struct.add(DWORD, "version", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

