/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pef.ContainerHeader;
import ghidra.app.util.bin.format.pef.ImportStateCache;
import ghidra.app.util.bin.format.pef.Relocation;
import ghidra.app.util.bin.format.pef.RelocationState;
import ghidra.app.util.bin.format.pef.SectionHeader;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class RelocLgSetOrBySection
extends Relocation {
    public static final int kPEFRelocLgBySection = 0;
    public static final int kPEFRelocLgSetSectC = 1;
    public static final int kPEFRelocLgSetSectD = 2;
    private int subopcode;
    private int index;

    RelocLgSetOrBySection(BinaryReader reader) throws IOException {
        int value = reader.readNextShort() & 0xFFFF;
        this.opcode = (value & 0xFC00) >> 10;
        this.subopcode = (value & 0x3C0) >> 6;
        this.index = (value & 0x3F) << 16;
        this.index |= reader.readNextShort() & 0xFFFF;
    }

    @Override
    public boolean isMatch() {
        return this.opcode == 45;
    }

    @Override
    public int getSizeInBytes() {
        return 4;
    }

    public int getSubopcode() {
        return this.subopcode;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String toString() {
        switch (this.subopcode) {
            case 0: {
                return "RelocLgBySection";
            }
            case 1: {
                return "RelocLgSetSectC";
            }
            case 2: {
                return "RelocLgSetSectD";
            }
        }
        return super.toString();
    }

    @Override
    public void apply(ImportStateCache importState, RelocationState relocState, ContainerHeader header, Program program, MessageLog log, TaskMonitor monitor) {
        switch (this.subopcode) {
            case 0: {
                SectionHeader sect = header.getSections().get(this.index);
                MemoryBlock block = importState.getMemoryBlockForSection(sect);
                relocState.relocateMemoryAt(relocState.getRelocationAddress(), (int)block.getStart().getOffset(), log);
                break;
            }
            case 1: {
                SectionHeader sectC = header.getSections().get(this.index);
                MemoryBlock blockC = importState.getMemoryBlockForSection(sectC);
                relocState.setSectionC(blockC.getStart());
                break;
            }
            case 2: {
                SectionHeader sectD = header.getSections().get(this.index);
                MemoryBlock blockD = importState.getMemoryBlockForSection(sectD);
                relocState.setSectionD(blockD.getStart());
                break;
            }
            default: {
                log.appendMsg("Unsupported RelocLgSetOrBySection subopcode: " + this.subopcode);
            }
        }
    }
}

