/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.bin.format.coff.CoffSectionHeader;
import ghidra.app.util.opinion.CoffLoader;
import java.util.Comparator;

public class MSCoffLoader
extends CoffLoader {
    public static final String MSCOFF_NAME = "MS Common Object File Format (COFF)";

    @Override
    public boolean isMicrosoftFormat() {
        return true;
    }

    @Override
    public String getName() {
        return MSCOFF_NAME;
    }

    @Override
    protected Comparator<String> getLibraryNameComparator() {
        return String.CASE_INSENSITIVE_ORDER;
    }

    @Override
    protected int getSectionAlignment(CoffSectionHeader section) {
        int s_flags = section.getFlags();
        int align_bits = (s_flags & 0xF00000) >> 20;
        if (align_bits == 0 || align_bits >= 15) {
            return 1;
        }
        return 1 << align_bits - 1;
    }
}

